/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.linkprediction;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.kernel.impl.core.NodeEntity;

public class NeighborsFinder {
    public Set<Node> findCommonNeighbors(Node node1, Node node2, RelationshipType relationshipType, Direction direction) {
        if (node1.equals(node2)) {
            return Collections.emptySet();
        }
        Set<Node> neighbors = this.findNeighbors(node1, relationshipType, direction);
        neighbors.removeIf(node -> this.noCommonNeighbors((Node)node, relationshipType, this.flipDirection(direction), node2));
        return neighbors;
    }

    public Set<Node> findNeighbors(Node node1, Node node2, RelationshipType relationshipType, Direction direction) {
        Set<Node> node1Neighbors = this.findNeighbors(node1, relationshipType, direction);
        Set<Node> node2Neighbors = this.findNeighbors(node2, relationshipType, direction);
        node1Neighbors.addAll(node2Neighbors);
        return node1Neighbors;
    }

    public Set<Node> findNeighbors(Node node, RelationshipType relationshipType, Direction direction) {
        HashSet<Node> neighbors = new HashSet<Node>();
        for (Relationship rel : this.loadRelationships((NodeEntity)node, relationshipType, direction)) {
            Node endNode = rel.getOtherNode(node);
            if (endNode.equals(node)) continue;
            neighbors.add(endNode);
        }
        return neighbors;
    }

    private Direction flipDirection(Direction direction) {
        switch (direction) {
            case OUTGOING: {
                return Direction.INCOMING;
            }
            case INCOMING: {
                return Direction.OUTGOING;
            }
        }
        return Direction.BOTH;
    }

    private boolean noCommonNeighbors(Node node, RelationshipType relationshipType, Direction direction, Node node2) {
        Iterator<Relationship> iter = this.loadRelationships((NodeEntity)node, relationshipType, direction).iterator();
        while (iter.hasNext()) {
            if (!iter.next().getOtherNode(node).equals(node2)) continue;
            iter.forEachRemaining(__ -> {});
            return false;
        }
        return true;
    }

    private Iterable<Relationship> loadRelationships(NodeEntity node, RelationshipType relationshipType, Direction direction) {
        return relationshipType == null ? node.getRelationships(direction) : node.getRelationships(direction, new RelationshipType[]{relationshipType});
    }
}

