/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.pregel;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.neo4j.gds.beta.pregel.PregelConfig;
import org.neo4j.gds.beta.pregel.PregelProcedureConfig;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.config.ConcurrencyConfig;
import org.neo4j.gds.config.JobIdConfig;
import org.neo4j.gds.config.MutateConfig;
import org.neo4j.gds.config.MutateNodePropertyConfig;
import org.neo4j.gds.config.RelationshipWeightConfig;
import org.neo4j.gds.config.WriteConfig;
import org.neo4j.gds.config.WritePropertyConfig;
import org.neo4j.gds.core.utils.progress.JobId;
import org.neo4j.gds.pregel.Hits;

@ParametersAreNonnullByDefault
@Generated(from="Hits.HitsConfig", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableHitsConfig
implements Hits.HitsConfig {
    @Nullable
    private final String usernameOverride;
    private final boolean sudo;
    private final boolean logProgress;
    private final Collection<String> configKeys;
    private final transient Map<String, Object> toMap;
    private final int concurrency;
    private final int minBatchSize;
    private final JobId jobId;
    private final List<String> relationshipTypes;
    private final List<String> nodeLabels;
    @Nullable
    private final String relationshipWeightProperty;
    private final transient boolean hasRelationshipWeightProperty;
    private final transient boolean useForkJoin;
    private final int writeConcurrency;
    @Nullable
    private final WriteConfig.ArrowConnectionInfo arrowConnectionInfo;
    private final String writeProperty;
    private final String mutateProperty;
    private final int hitsIterations;
    private final transient int maxIterations;
    private final transient boolean isAsynchronous;
    private final String hubProperty;
    private final String authProperty;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableHitsConfig(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, Optional<String> relationshipWeightProperty, int writeConcurrency, Optional<? extends WriteConfig.ArrowConnectionInfo> arrowConnectionInfo, String writeProperty, String mutateProperty, int hitsIterations, String hubProperty, String authProperty) {
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.relationshipTypes(ImmutableHitsConfig.createUnmodifiableList(false, ImmutableHitsConfig.createSafeList(relationshipTypes, true, false)));
        this.initShim.nodeLabels(ImmutableHitsConfig.createUnmodifiableList(false, ImmutableHitsConfig.createSafeList(nodeLabels, true, false)));
        this.relationshipWeightProperty = relationshipWeightProperty.orElse(null);
        this.initShim.writeConcurrency(writeConcurrency);
        this.arrowConnectionInfo = arrowConnectionInfo.orElse(null);
        this.initShim.writeProperty(Objects.requireNonNull(writeProperty, "writeProperty"));
        this.initShim.mutateProperty(Objects.requireNonNull(mutateProperty, "mutateProperty"));
        this.hitsIterations = hitsIterations;
        this.initShim.hubProperty(Objects.requireNonNull(hubProperty, "hubProperty"));
        this.initShim.authProperty(Objects.requireNonNull(authProperty, "authProperty"));
        this.usernameOverride = null;
        this.sudo = this.initShim.sudo();
        this.logProgress = this.initShim.logProgress();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.jobId = this.initShim.jobId();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.useForkJoin = this.initShim.useForkJoin();
        this.writeConcurrency = this.initShim.writeConcurrency();
        this.writeProperty = this.initShim.writeProperty();
        this.mutateProperty = this.initShim.mutateProperty();
        this.maxIterations = this.initShim.maxIterations();
        this.isAsynchronous = this.initShim.isAsynchronous();
        this.hubProperty = this.initShim.hubProperty();
        this.authProperty = this.initShim.authProperty();
        this.initShim = null;
    }

    private ImmutableHitsConfig(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, @Nullable String relationshipWeightProperty, int writeConcurrency, @Nullable WriteConfig.ArrowConnectionInfo arrowConnectionInfo, String writeProperty, String mutateProperty, int hitsIterations, String hubProperty, String authProperty) {
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.relationshipTypes(ImmutableHitsConfig.createUnmodifiableList(false, ImmutableHitsConfig.createSafeList(relationshipTypes, true, false)));
        this.initShim.nodeLabels(ImmutableHitsConfig.createUnmodifiableList(false, ImmutableHitsConfig.createSafeList(nodeLabels, true, false)));
        this.relationshipWeightProperty = relationshipWeightProperty;
        this.initShim.writeConcurrency(writeConcurrency);
        this.arrowConnectionInfo = arrowConnectionInfo;
        this.initShim.writeProperty(Objects.requireNonNull(writeProperty, "writeProperty"));
        this.initShim.mutateProperty(Objects.requireNonNull(mutateProperty, "mutateProperty"));
        this.hitsIterations = hitsIterations;
        this.initShim.hubProperty(Objects.requireNonNull(hubProperty, "hubProperty"));
        this.initShim.authProperty(Objects.requireNonNull(authProperty, "authProperty"));
        this.usernameOverride = null;
        this.sudo = this.initShim.sudo();
        this.logProgress = this.initShim.logProgress();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.jobId = this.initShim.jobId();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.useForkJoin = this.initShim.useForkJoin();
        this.writeConcurrency = this.initShim.writeConcurrency();
        this.writeProperty = this.initShim.writeProperty();
        this.mutateProperty = this.initShim.mutateProperty();
        this.maxIterations = this.initShim.maxIterations();
        this.isAsynchronous = this.initShim.isAsynchronous();
        this.hubProperty = this.initShim.hubProperty();
        this.authProperty = this.initShim.authProperty();
        this.initShim = null;
    }

    private ImmutableHitsConfig(Builder builder) {
        this.usernameOverride = builder.usernameOverride;
        this.relationshipWeightProperty = builder.relationshipWeightProperty;
        this.arrowConnectionInfo = builder.arrowConnectionInfo;
        this.hitsIterations = builder.hitsIterations;
        if (builder.sudoIsSet()) {
            this.initShim.sudo(builder.sudo);
        }
        if (builder.logProgressIsSet()) {
            this.initShim.logProgress(builder.logProgress);
        }
        if (builder.configKeys != null) {
            this.initShim.configKeys(builder.configKeys);
        }
        if (builder.concurrencyIsSet()) {
            this.initShim.concurrency(builder.concurrency);
        }
        if (builder.minBatchSizeIsSet()) {
            this.initShim.minBatchSize(builder.minBatchSize);
        }
        if (builder.jobId != null) {
            this.initShim.jobId(builder.jobId);
        }
        if (builder.relationshipTypesIsSet()) {
            this.initShim.relationshipTypes(builder.relationshipTypes == null ? Collections.emptyList() : ImmutableHitsConfig.createUnmodifiableList(true, builder.relationshipTypes));
        }
        if (builder.nodeLabelsIsSet()) {
            this.initShim.nodeLabels(builder.nodeLabels == null ? Collections.emptyList() : ImmutableHitsConfig.createUnmodifiableList(true, builder.nodeLabels));
        }
        if (builder.writeConcurrencyIsSet()) {
            this.initShim.writeConcurrency(builder.writeConcurrency);
        }
        if (builder.writeProperty != null) {
            this.initShim.writeProperty(builder.writeProperty);
        }
        if (builder.mutateProperty != null) {
            this.initShim.mutateProperty(builder.mutateProperty);
        }
        if (builder.hubProperty != null) {
            this.initShim.hubProperty(builder.hubProperty);
        }
        if (builder.authProperty != null) {
            this.initShim.authProperty(builder.authProperty);
        }
        this.sudo = this.initShim.sudo();
        this.logProgress = this.initShim.logProgress();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.jobId = this.initShim.jobId();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.useForkJoin = this.initShim.useForkJoin();
        this.writeConcurrency = this.initShim.writeConcurrency();
        this.writeProperty = this.initShim.writeProperty();
        this.mutateProperty = this.initShim.mutateProperty();
        this.maxIterations = this.initShim.maxIterations();
        this.isAsynchronous = this.initShim.isAsynchronous();
        this.hubProperty = this.initShim.hubProperty();
        this.authProperty = this.initShim.authProperty();
        this.initShim = null;
    }

    private ImmutableHitsConfig(@Nullable String usernameOverride, boolean sudo, boolean logProgress, Collection<String> configKeys, int concurrency, int minBatchSize, JobId jobId, List<String> relationshipTypes, List<String> nodeLabels, @Nullable String relationshipWeightProperty, int writeConcurrency, @Nullable WriteConfig.ArrowConnectionInfo arrowConnectionInfo, String writeProperty, String mutateProperty, int hitsIterations, String hubProperty, String authProperty) {
        this.usernameOverride = usernameOverride;
        this.initShim.sudo(sudo);
        this.initShim.logProgress(logProgress);
        this.initShim.configKeys(configKeys);
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.jobId(jobId);
        this.initShim.relationshipTypes(relationshipTypes);
        this.initShim.nodeLabels(nodeLabels);
        this.relationshipWeightProperty = relationshipWeightProperty;
        this.initShim.writeConcurrency(writeConcurrency);
        this.arrowConnectionInfo = arrowConnectionInfo;
        this.initShim.writeProperty(writeProperty);
        this.initShim.mutateProperty(mutateProperty);
        this.hitsIterations = hitsIterations;
        this.initShim.hubProperty(hubProperty);
        this.initShim.authProperty(authProperty);
        this.sudo = this.initShim.sudo();
        this.logProgress = this.initShim.logProgress();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.jobId = this.initShim.jobId();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.useForkJoin = this.initShim.useForkJoin();
        this.writeConcurrency = this.initShim.writeConcurrency();
        this.writeProperty = this.initShim.writeProperty();
        this.mutateProperty = this.initShim.mutateProperty();
        this.maxIterations = this.initShim.maxIterations();
        this.isAsynchronous = this.initShim.isAsynchronous();
        this.hubProperty = this.initShim.hubProperty();
        this.authProperty = this.initShim.authProperty();
        this.initShim = null;
    }

    private boolean sudoInitialize() {
        return Hits.HitsConfig.super.sudo();
    }

    private boolean logProgressInitialize() {
        return Hits.HitsConfig.super.logProgress();
    }

    private Collection<String> configKeysInitialize() {
        return Hits.HitsConfig.super.configKeys();
    }

    private Map<String, Object> toMapInitialize() {
        return Hits.HitsConfig.super.toMap();
    }

    private int concurrencyInitialize() {
        return Hits.HitsConfig.super.concurrency();
    }

    private int minBatchSizeInitialize() {
        return Hits.HitsConfig.super.minBatchSize();
    }

    private JobId jobIdInitialize() {
        return Hits.HitsConfig.super.jobId();
    }

    private List<String> relationshipTypesInitialize() {
        return Hits.HitsConfig.super.relationshipTypes();
    }

    private List<String> nodeLabelsInitialize() {
        return Hits.HitsConfig.super.nodeLabels();
    }

    private boolean hasRelationshipWeightPropertyInitialize() {
        return Hits.HitsConfig.super.hasRelationshipWeightProperty();
    }

    private boolean useForkJoinInitialize() {
        return Hits.HitsConfig.super.useForkJoin();
    }

    private int writeConcurrencyInitialize() {
        return Hits.HitsConfig.super.writeConcurrency();
    }

    private String writePropertyInitialize() {
        return Hits.HitsConfig.super.writeProperty();
    }

    private String mutatePropertyInitialize() {
        return Hits.HitsConfig.super.mutateProperty();
    }

    private int maxIterationsInitialize() {
        return Hits.HitsConfig.super.maxIterations();
    }

    private boolean isAsynchronousInitialize() {
        return Hits.HitsConfig.super.isAsynchronous();
    }

    private String hubPropertyInitialize() {
        return Hits.HitsConfig.super.hubProperty();
    }

    private String authPropertyInitialize() {
        return Hits.HitsConfig.super.authProperty();
    }

    public Optional<String> usernameOverride() {
        return Optional.ofNullable(this.usernameOverride);
    }

    public boolean sudo() {
        InitShim shim = this.initShim;
        return shim != null ? shim.sudo() : this.sudo;
    }

    public boolean logProgress() {
        InitShim shim = this.initShim;
        return shim != null ? shim.logProgress() : this.logProgress;
    }

    public Collection<String> configKeys() {
        InitShim shim = this.initShim;
        return shim != null ? shim.configKeys() : this.configKeys;
    }

    public Map<String, Object> toMap() {
        InitShim shim = this.initShim;
        return shim != null ? shim.toMap() : this.toMap;
    }

    public int concurrency() {
        InitShim shim = this.initShim;
        return shim != null ? shim.concurrency() : this.concurrency;
    }

    public int minBatchSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.minBatchSize() : this.minBatchSize;
    }

    public JobId jobId() {
        InitShim shim = this.initShim;
        return shim != null ? shim.jobId() : this.jobId;
    }

    public List<String> relationshipTypes() {
        InitShim shim = this.initShim;
        return shim != null ? shim.relationshipTypes() : this.relationshipTypes;
    }

    public List<String> nodeLabels() {
        InitShim shim = this.initShim;
        return shim != null ? shim.nodeLabels() : this.nodeLabels;
    }

    public Optional<String> relationshipWeightProperty() {
        return Optional.ofNullable(this.relationshipWeightProperty);
    }

    public boolean hasRelationshipWeightProperty() {
        InitShim shim = this.initShim;
        return shim != null ? shim.hasRelationshipWeightProperty() : this.hasRelationshipWeightProperty;
    }

    public boolean useForkJoin() {
        InitShim shim = this.initShim;
        return shim != null ? shim.useForkJoin() : this.useForkJoin;
    }

    public int writeConcurrency() {
        InitShim shim = this.initShim;
        return shim != null ? shim.writeConcurrency() : this.writeConcurrency;
    }

    public Optional<WriteConfig.ArrowConnectionInfo> arrowConnectionInfo() {
        return Optional.ofNullable(this.arrowConnectionInfo);
    }

    public String writeProperty() {
        InitShim shim = this.initShim;
        return shim != null ? shim.writeProperty() : this.writeProperty;
    }

    public String mutateProperty() {
        InitShim shim = this.initShim;
        return shim != null ? shim.mutateProperty() : this.mutateProperty;
    }

    @Override
    public int hitsIterations() {
        return this.hitsIterations;
    }

    @Override
    public int maxIterations() {
        InitShim shim = this.initShim;
        return shim != null ? shim.maxIterations() : this.maxIterations;
    }

    @Override
    public boolean isAsynchronous() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isAsynchronous() : this.isAsynchronous;
    }

    @Override
    public String hubProperty() {
        InitShim shim = this.initShim;
        return shim != null ? shim.hubProperty() : this.hubProperty;
    }

    @Override
    public String authProperty() {
        InitShim shim = this.initShim;
        return shim != null ? shim.authProperty() : this.authProperty;
    }

    public final ImmutableHitsConfig withUsernameOverride(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.usernameOverride, newValue)) {
            return this;
        }
        return ImmutableHitsConfig.validate(new ImmutableHitsConfig(newValue, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.writeConcurrency, this.arrowConnectionInfo, this.writeProperty, this.mutateProperty, this.hitsIterations, this.hubProperty, this.authProperty));
    }

    public final ImmutableHitsConfig withUsernameOverride(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.usernameOverride, value)) {
            return this;
        }
        return ImmutableHitsConfig.validate(new ImmutableHitsConfig(value, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.writeConcurrency, this.arrowConnectionInfo, this.writeProperty, this.mutateProperty, this.hitsIterations, this.hubProperty, this.authProperty));
    }

    public final ImmutableHitsConfig withSudo(boolean value) {
        if (this.sudo == value) {
            return this;
        }
        return ImmutableHitsConfig.validate(new ImmutableHitsConfig(this.usernameOverride, value, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.writeConcurrency, this.arrowConnectionInfo, this.writeProperty, this.mutateProperty, this.hitsIterations, this.hubProperty, this.authProperty));
    }

    public final ImmutableHitsConfig withLogProgress(boolean value) {
        if (this.logProgress == value) {
            return this;
        }
        return ImmutableHitsConfig.validate(new ImmutableHitsConfig(this.usernameOverride, this.sudo, value, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.writeConcurrency, this.arrowConnectionInfo, this.writeProperty, this.mutateProperty, this.hitsIterations, this.hubProperty, this.authProperty));
    }

    public final ImmutableHitsConfig withConfigKeys(Collection<String> value) {
        if (this.configKeys == value) {
            return this;
        }
        Collection<String> newValue = Objects.requireNonNull(value, "configKeys");
        return ImmutableHitsConfig.validate(new ImmutableHitsConfig(this.usernameOverride, this.sudo, this.logProgress, newValue, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.writeConcurrency, this.arrowConnectionInfo, this.writeProperty, this.mutateProperty, this.hitsIterations, this.hubProperty, this.authProperty));
    }

    public final ImmutableHitsConfig withConcurrency(int value) {
        if (this.concurrency == value) {
            return this;
        }
        return ImmutableHitsConfig.validate(new ImmutableHitsConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, value, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.writeConcurrency, this.arrowConnectionInfo, this.writeProperty, this.mutateProperty, this.hitsIterations, this.hubProperty, this.authProperty));
    }

    public final ImmutableHitsConfig withMinBatchSize(int value) {
        if (this.minBatchSize == value) {
            return this;
        }
        return ImmutableHitsConfig.validate(new ImmutableHitsConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, value, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.writeConcurrency, this.arrowConnectionInfo, this.writeProperty, this.mutateProperty, this.hitsIterations, this.hubProperty, this.authProperty));
    }

    public final ImmutableHitsConfig withJobId(JobId value) {
        if (this.jobId == value) {
            return this;
        }
        JobId newValue = Objects.requireNonNull(value, "jobId");
        return ImmutableHitsConfig.validate(new ImmutableHitsConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, newValue, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.writeConcurrency, this.arrowConnectionInfo, this.writeProperty, this.mutateProperty, this.hitsIterations, this.hubProperty, this.authProperty));
    }

    public final ImmutableHitsConfig withRelationshipTypes(String ... elements) {
        List<String> newValue = ImmutableHitsConfig.createUnmodifiableList(false, ImmutableHitsConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableHitsConfig.validate(new ImmutableHitsConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, newValue, this.nodeLabels, this.relationshipWeightProperty, this.writeConcurrency, this.arrowConnectionInfo, this.writeProperty, this.mutateProperty, this.hitsIterations, this.hubProperty, this.authProperty));
    }

    public final ImmutableHitsConfig withRelationshipTypes(Iterable<String> elements) {
        if (this.relationshipTypes == elements) {
            return this;
        }
        List<String> newValue = ImmutableHitsConfig.createUnmodifiableList(false, ImmutableHitsConfig.createSafeList(elements, true, false));
        return ImmutableHitsConfig.validate(new ImmutableHitsConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, newValue, this.nodeLabels, this.relationshipWeightProperty, this.writeConcurrency, this.arrowConnectionInfo, this.writeProperty, this.mutateProperty, this.hitsIterations, this.hubProperty, this.authProperty));
    }

    public final ImmutableHitsConfig withNodeLabels(String ... elements) {
        List<String> newValue = ImmutableHitsConfig.createUnmodifiableList(false, ImmutableHitsConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableHitsConfig.validate(new ImmutableHitsConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, newValue, this.relationshipWeightProperty, this.writeConcurrency, this.arrowConnectionInfo, this.writeProperty, this.mutateProperty, this.hitsIterations, this.hubProperty, this.authProperty));
    }

    public final ImmutableHitsConfig withNodeLabels(Iterable<String> elements) {
        if (this.nodeLabels == elements) {
            return this;
        }
        List<String> newValue = ImmutableHitsConfig.createUnmodifiableList(false, ImmutableHitsConfig.createSafeList(elements, true, false));
        return ImmutableHitsConfig.validate(new ImmutableHitsConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, newValue, this.relationshipWeightProperty, this.writeConcurrency, this.arrowConnectionInfo, this.writeProperty, this.mutateProperty, this.hitsIterations, this.hubProperty, this.authProperty));
    }

    public final ImmutableHitsConfig withRelationshipWeightProperty(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.relationshipWeightProperty, newValue)) {
            return this;
        }
        return ImmutableHitsConfig.validate(new ImmutableHitsConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, newValue, this.writeConcurrency, this.arrowConnectionInfo, this.writeProperty, this.mutateProperty, this.hitsIterations, this.hubProperty, this.authProperty));
    }

    public final ImmutableHitsConfig withRelationshipWeightProperty(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.relationshipWeightProperty, value)) {
            return this;
        }
        return ImmutableHitsConfig.validate(new ImmutableHitsConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, value, this.writeConcurrency, this.arrowConnectionInfo, this.writeProperty, this.mutateProperty, this.hitsIterations, this.hubProperty, this.authProperty));
    }

    public final ImmutableHitsConfig withWriteConcurrency(int value) {
        if (this.writeConcurrency == value) {
            return this;
        }
        return ImmutableHitsConfig.validate(new ImmutableHitsConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, value, this.arrowConnectionInfo, this.writeProperty, this.mutateProperty, this.hitsIterations, this.hubProperty, this.authProperty));
    }

    public final ImmutableHitsConfig withArrowConnectionInfo(@Nullable WriteConfig.ArrowConnectionInfo value) {
        WriteConfig.ArrowConnectionInfo newValue = value;
        if (this.arrowConnectionInfo == newValue) {
            return this;
        }
        return ImmutableHitsConfig.validate(new ImmutableHitsConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.writeConcurrency, newValue, this.writeProperty, this.mutateProperty, this.hitsIterations, this.hubProperty, this.authProperty));
    }

    public final ImmutableHitsConfig withArrowConnectionInfo(Optional<? extends WriteConfig.ArrowConnectionInfo> optional) {
        WriteConfig.ArrowConnectionInfo value = optional.orElse(null);
        if (this.arrowConnectionInfo == value) {
            return this;
        }
        return ImmutableHitsConfig.validate(new ImmutableHitsConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.writeConcurrency, value, this.writeProperty, this.mutateProperty, this.hitsIterations, this.hubProperty, this.authProperty));
    }

    public final ImmutableHitsConfig withWriteProperty(String value) {
        String newValue = Objects.requireNonNull(value, "writeProperty");
        if (this.writeProperty.equals(newValue)) {
            return this;
        }
        return ImmutableHitsConfig.validate(new ImmutableHitsConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.writeConcurrency, this.arrowConnectionInfo, newValue, this.mutateProperty, this.hitsIterations, this.hubProperty, this.authProperty));
    }

    public final ImmutableHitsConfig withMutateProperty(String value) {
        String newValue = Objects.requireNonNull(value, "mutateProperty");
        if (this.mutateProperty.equals(newValue)) {
            return this;
        }
        return ImmutableHitsConfig.validate(new ImmutableHitsConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.writeConcurrency, this.arrowConnectionInfo, this.writeProperty, newValue, this.hitsIterations, this.hubProperty, this.authProperty));
    }

    public final ImmutableHitsConfig withHitsIterations(int value) {
        if (this.hitsIterations == value) {
            return this;
        }
        return ImmutableHitsConfig.validate(new ImmutableHitsConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.writeConcurrency, this.arrowConnectionInfo, this.writeProperty, this.mutateProperty, value, this.hubProperty, this.authProperty));
    }

    public final ImmutableHitsConfig withHubProperty(String value) {
        String newValue = Objects.requireNonNull(value, "hubProperty");
        if (this.hubProperty.equals(newValue)) {
            return this;
        }
        return ImmutableHitsConfig.validate(new ImmutableHitsConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.writeConcurrency, this.arrowConnectionInfo, this.writeProperty, this.mutateProperty, this.hitsIterations, newValue, this.authProperty));
    }

    public final ImmutableHitsConfig withAuthProperty(String value) {
        String newValue = Objects.requireNonNull(value, "authProperty");
        if (this.authProperty.equals(newValue)) {
            return this;
        }
        return ImmutableHitsConfig.validate(new ImmutableHitsConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.writeConcurrency, this.arrowConnectionInfo, this.writeProperty, this.mutateProperty, this.hitsIterations, this.hubProperty, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableHitsConfig && this.equalTo(0, (ImmutableHitsConfig)another);
    }

    private boolean equalTo(int synthetic, ImmutableHitsConfig another) {
        return Objects.equals(this.usernameOverride, another.usernameOverride) && this.sudo == another.sudo && this.logProgress == another.logProgress && this.concurrency == another.concurrency && this.minBatchSize == another.minBatchSize && this.jobId.equals((Object)another.jobId) && this.relationshipTypes.equals(another.relationshipTypes) && this.nodeLabels.equals(another.nodeLabels) && Objects.equals(this.relationshipWeightProperty, another.relationshipWeightProperty) && this.hasRelationshipWeightProperty == another.hasRelationshipWeightProperty && this.useForkJoin == another.useForkJoin && this.writeConcurrency == another.writeConcurrency && Objects.equals(this.arrowConnectionInfo, another.arrowConnectionInfo) && this.writeProperty.equals(another.writeProperty) && this.mutateProperty.equals(another.mutateProperty) && this.hitsIterations == another.hitsIterations && this.maxIterations == another.maxIterations && this.isAsynchronous == another.isAsynchronous && this.hubProperty.equals(another.hubProperty) && this.authProperty.equals(another.authProperty);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.usernameOverride);
        h += (h << 5) + Boolean.hashCode(this.sudo);
        h += (h << 5) + Boolean.hashCode(this.logProgress);
        h += (h << 5) + this.concurrency;
        h += (h << 5) + this.minBatchSize;
        h += (h << 5) + this.jobId.hashCode();
        h += (h << 5) + this.relationshipTypes.hashCode();
        h += (h << 5) + this.nodeLabels.hashCode();
        h += (h << 5) + Objects.hashCode(this.relationshipWeightProperty);
        h += (h << 5) + Boolean.hashCode(this.hasRelationshipWeightProperty);
        h += (h << 5) + Boolean.hashCode(this.useForkJoin);
        h += (h << 5) + this.writeConcurrency;
        h += (h << 5) + Objects.hashCode(this.arrowConnectionInfo);
        h += (h << 5) + this.writeProperty.hashCode();
        h += (h << 5) + this.mutateProperty.hashCode();
        h += (h << 5) + this.hitsIterations;
        h += (h << 5) + this.maxIterations;
        h += (h << 5) + Boolean.hashCode(this.isAsynchronous);
        h += (h << 5) + this.hubProperty.hashCode();
        h += (h << 5) + this.authProperty.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("HitsConfig{");
        if (this.usernameOverride != null) {
            builder.append("usernameOverride=").append(this.usernameOverride);
        }
        if (builder.length() > 11) {
            builder.append(", ");
        }
        builder.append("sudo=").append(this.sudo);
        builder.append(", ");
        builder.append("logProgress=").append(this.logProgress);
        builder.append(", ");
        builder.append("concurrency=").append(this.concurrency);
        builder.append(", ");
        builder.append("minBatchSize=").append(this.minBatchSize);
        builder.append(", ");
        builder.append("jobId=").append(this.jobId);
        builder.append(", ");
        builder.append("relationshipTypes=").append(this.relationshipTypes);
        builder.append(", ");
        builder.append("nodeLabels=").append(this.nodeLabels);
        if (this.relationshipWeightProperty != null) {
            builder.append(", ");
            builder.append("relationshipWeightProperty=").append(this.relationshipWeightProperty);
        }
        builder.append(", ");
        builder.append("hasRelationshipWeightProperty=").append(this.hasRelationshipWeightProperty);
        builder.append(", ");
        builder.append("useForkJoin=").append(this.useForkJoin);
        builder.append(", ");
        builder.append("writeConcurrency=").append(this.writeConcurrency);
        if (this.arrowConnectionInfo != null) {
            builder.append(", ");
            builder.append("arrowConnectionInfo=").append(this.arrowConnectionInfo);
        }
        builder.append(", ");
        builder.append("writeProperty=").append(this.writeProperty);
        builder.append(", ");
        builder.append("mutateProperty=").append(this.mutateProperty);
        builder.append(", ");
        builder.append("hitsIterations=").append(this.hitsIterations);
        builder.append(", ");
        builder.append("maxIterations=").append(this.maxIterations);
        builder.append(", ");
        builder.append("isAsynchronous=").append(this.isAsynchronous);
        builder.append(", ");
        builder.append("hubProperty=").append(this.hubProperty);
        builder.append(", ");
        builder.append("authProperty=").append(this.authProperty);
        return builder.append("}").toString();
    }

    public static Hits.HitsConfig of(int concurrency, int minBatchSize, List<String> relationshipTypes, List<String> nodeLabels, Optional<String> relationshipWeightProperty, int writeConcurrency, Optional<WriteConfig.ArrowConnectionInfo> arrowConnectionInfo, String writeProperty, String mutateProperty, int hitsIterations, String hubProperty, String authProperty) {
        return ImmutableHitsConfig.of(concurrency, minBatchSize, relationshipTypes, nodeLabels, relationshipWeightProperty, writeConcurrency, arrowConnectionInfo, writeProperty, mutateProperty, hitsIterations, hubProperty, authProperty);
    }

    public static Hits.HitsConfig of(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, Optional<String> relationshipWeightProperty, int writeConcurrency, Optional<? extends WriteConfig.ArrowConnectionInfo> arrowConnectionInfo, String writeProperty, String mutateProperty, int hitsIterations, String hubProperty, String authProperty) {
        return ImmutableHitsConfig.validate(new ImmutableHitsConfig(concurrency, minBatchSize, relationshipTypes, nodeLabels, relationshipWeightProperty, writeConcurrency, arrowConnectionInfo, writeProperty, mutateProperty, hitsIterations, hubProperty, authProperty));
    }

    public static Hits.HitsConfig of(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, @Nullable String relationshipWeightProperty, int writeConcurrency, @Nullable WriteConfig.ArrowConnectionInfo arrowConnectionInfo, String writeProperty, String mutateProperty, int hitsIterations, String hubProperty, String authProperty) {
        return ImmutableHitsConfig.validate(new ImmutableHitsConfig(concurrency, minBatchSize, relationshipTypes, nodeLabels, relationshipWeightProperty, writeConcurrency, arrowConnectionInfo, writeProperty, mutateProperty, hitsIterations, hubProperty, authProperty));
    }

    private static ImmutableHitsConfig validate(ImmutableHitsConfig instance) {
        instance.validateWriteConcurrency();
        instance.validateRelationshipWeightProperty();
        instance.validateConcurrency();
        return instance;
    }

    public static Hits.HitsConfig copyOf(Hits.HitsConfig instance) {
        if (instance instanceof ImmutableHitsConfig) {
            return (ImmutableHitsConfig)instance;
        }
        return ImmutableHitsConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="Hits.HitsConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_HITS_ITERATIONS = 1L;
        private static final long OPT_BIT_SUDO = 1L;
        private static final long OPT_BIT_LOG_PROGRESS = 2L;
        private static final long OPT_BIT_CONCURRENCY = 4L;
        private static final long OPT_BIT_MIN_BATCH_SIZE = 8L;
        private static final long OPT_BIT_RELATIONSHIP_TYPES = 16L;
        private static final long OPT_BIT_NODE_LABELS = 32L;
        private static final long OPT_BIT_WRITE_CONCURRENCY = 64L;
        private long initBits = 1L;
        private long optBits;
        @Nullable
        private String usernameOverride;
        private boolean sudo;
        private boolean logProgress;
        @Nullable
        private Collection<String> configKeys;
        private int concurrency;
        private int minBatchSize;
        @Nullable
        private JobId jobId;
        private List<String> relationshipTypes = null;
        private List<String> nodeLabels = null;
        @Nullable
        private String relationshipWeightProperty;
        private int writeConcurrency;
        @Nullable
        private WriteConfig.ArrowConnectionInfo arrowConnectionInfo;
        @Nullable
        private String writeProperty;
        @Nullable
        private String mutateProperty;
        private int hitsIterations;
        @Nullable
        private String hubProperty;
        @Nullable
        private String authProperty;

        private Builder() {
        }

        public final Builder from(MutateConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(RelationshipWeightConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(WritePropertyConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(WriteConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(JobIdConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ConcurrencyConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PregelProcedureConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Hits.HitsConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PregelConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AlgoBaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MutateNodePropertyConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Optional arrowConnectionInfoOptional;
            Optional relationshipWeightPropertyOptional;
            Optional usernameOverrideOptional;
            Object instance;
            long bits = 0L;
            if (object instanceof MutateConfig) {
                instance = (MutateConfig)object;
                if ((bits & 0x20L) == 0L) {
                    this.minBatchSize(instance.minBatchSize());
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    this.jobId(instance.jobId());
                    bits |= 0x40L;
                }
                if ((bits & 2L) == 0L) {
                    usernameOverrideOptional = instance.usernameOverride();
                    if (usernameOverrideOptional.isPresent()) {
                        this.usernameOverride(usernameOverrideOptional);
                    }
                    bits |= 2L;
                }
                if ((bits & 0x100L) == 0L) {
                    this.logProgress(instance.logProgress());
                    bits |= 0x100L;
                }
                if ((bits & 0x200L) == 0L) {
                    this.sudo(instance.sudo());
                    bits |= 0x200L;
                }
                if ((bits & 0x400L) == 0L) {
                    this.addAllNodeLabels(instance.nodeLabels());
                    bits |= 0x400L;
                }
                if ((bits & 0x800L) == 0L) {
                    this.addAllRelationshipTypes(instance.relationshipTypes());
                    bits |= 0x800L;
                }
                if ((bits & 0x1000L) == 0L) {
                    this.configKeys(instance.configKeys());
                    bits |= 0x1000L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.concurrency(instance.concurrency());
                    bits |= 0x10L;
                }
            }
            if (object instanceof RelationshipWeightConfig) {
                instance = (RelationshipWeightConfig)object;
                if ((bits & 4L) == 0L) {
                    relationshipWeightPropertyOptional = instance.relationshipWeightProperty();
                    if (relationshipWeightPropertyOptional.isPresent()) {
                        this.relationshipWeightProperty(relationshipWeightPropertyOptional);
                    }
                    bits |= 4L;
                }
            }
            if (object instanceof WritePropertyConfig) {
                instance = (WritePropertyConfig)object;
                if ((bits & 0x20L) == 0L) {
                    this.minBatchSize(instance.minBatchSize());
                    bits |= 0x20L;
                }
                if ((bits & 1L) == 0L) {
                    this.writeConcurrency(instance.writeConcurrency());
                    bits |= 1L;
                }
                if ((bits & 8L) == 0L) {
                    arrowConnectionInfoOptional = instance.arrowConnectionInfo();
                    if (arrowConnectionInfoOptional.isPresent()) {
                        this.arrowConnectionInfo(arrowConnectionInfoOptional);
                    }
                    bits |= 8L;
                }
                if ((bits & 0x80L) == 0L) {
                    this.writeProperty(instance.writeProperty());
                    bits |= 0x80L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.concurrency(instance.concurrency());
                    bits |= 0x10L;
                }
            }
            if (object instanceof WriteConfig) {
                instance = (WriteConfig)object;
                if ((bits & 0x20L) == 0L) {
                    this.minBatchSize(instance.minBatchSize());
                    bits |= 0x20L;
                }
                if ((bits & 1L) == 0L) {
                    this.writeConcurrency(instance.writeConcurrency());
                    bits |= 1L;
                }
                if ((bits & 8L) == 0L) {
                    arrowConnectionInfoOptional = instance.arrowConnectionInfo();
                    if (arrowConnectionInfoOptional.isPresent()) {
                        this.arrowConnectionInfo(arrowConnectionInfoOptional);
                    }
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.concurrency(instance.concurrency());
                    bits |= 0x10L;
                }
            }
            if (object instanceof JobIdConfig) {
                instance = (JobIdConfig)object;
                if ((bits & 0x40L) == 0L) {
                    this.jobId(instance.jobId());
                    bits |= 0x40L;
                }
            }
            if (object instanceof ConcurrencyConfig) {
                instance = (ConcurrencyConfig)object;
                if ((bits & 0x20L) == 0L) {
                    this.minBatchSize(instance.minBatchSize());
                    bits |= 0x20L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.concurrency(instance.concurrency());
                    bits |= 0x10L;
                }
            }
            if (object instanceof PregelProcedureConfig) {
                instance = (PregelProcedureConfig)object;
                if ((bits & 1L) == 0L) {
                    this.writeConcurrency(instance.writeConcurrency());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    usernameOverrideOptional = instance.usernameOverride();
                    if (usernameOverrideOptional.isPresent()) {
                        this.usernameOverride(usernameOverrideOptional);
                    }
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    relationshipWeightPropertyOptional = instance.relationshipWeightProperty();
                    if (relationshipWeightPropertyOptional.isPresent()) {
                        this.relationshipWeightProperty(relationshipWeightPropertyOptional);
                    }
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    arrowConnectionInfoOptional = instance.arrowConnectionInfo();
                    if (arrowConnectionInfoOptional.isPresent()) {
                        this.arrowConnectionInfo(arrowConnectionInfoOptional);
                    }
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.concurrency(instance.concurrency());
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.minBatchSize(instance.minBatchSize());
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    this.jobId(instance.jobId());
                    bits |= 0x40L;
                }
                if ((bits & 0x80L) == 0L) {
                    this.writeProperty(instance.writeProperty());
                    bits |= 0x80L;
                }
                if ((bits & 0x100L) == 0L) {
                    this.logProgress(instance.logProgress());
                    bits |= 0x100L;
                }
                if ((bits & 0x200L) == 0L) {
                    this.sudo(instance.sudo());
                    bits |= 0x200L;
                }
                if ((bits & 0x400L) == 0L) {
                    this.addAllNodeLabels(instance.nodeLabels());
                    bits |= 0x400L;
                }
                if ((bits & 0x800L) == 0L) {
                    this.addAllRelationshipTypes(instance.relationshipTypes());
                    bits |= 0x800L;
                }
                if ((bits & 0x1000L) == 0L) {
                    this.configKeys(instance.configKeys());
                    bits |= 0x1000L;
                }
                if ((bits & 0x2000L) == 0L) {
                    this.mutateProperty(instance.mutateProperty());
                    bits |= 0x2000L;
                }
            }
            if (object instanceof Hits.HitsConfig) {
                instance = (Hits.HitsConfig)object;
                if ((bits & 1L) == 0L) {
                    this.writeConcurrency(instance.writeConcurrency());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    usernameOverrideOptional = instance.usernameOverride();
                    if (usernameOverrideOptional.isPresent()) {
                        this.usernameOverride(usernameOverrideOptional);
                    }
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    relationshipWeightPropertyOptional = instance.relationshipWeightProperty();
                    if (relationshipWeightPropertyOptional.isPresent()) {
                        this.relationshipWeightProperty(relationshipWeightPropertyOptional);
                    }
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    arrowConnectionInfoOptional = instance.arrowConnectionInfo();
                    if (arrowConnectionInfoOptional.isPresent()) {
                        this.arrowConnectionInfo(arrowConnectionInfoOptional);
                    }
                    bits |= 8L;
                }
                this.hitsIterations(instance.hitsIterations());
                this.authProperty(instance.authProperty());
                if ((bits & 0x10L) == 0L) {
                    this.concurrency(instance.concurrency());
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.minBatchSize(instance.minBatchSize());
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    this.jobId(instance.jobId());
                    bits |= 0x40L;
                }
                if ((bits & 0x80L) == 0L) {
                    this.writeProperty(instance.writeProperty());
                    bits |= 0x80L;
                }
                if ((bits & 0x100L) == 0L) {
                    this.logProgress(instance.logProgress());
                    bits |= 0x100L;
                }
                if ((bits & 0x200L) == 0L) {
                    this.sudo(instance.sudo());
                    bits |= 0x200L;
                }
                if ((bits & 0x400L) == 0L) {
                    this.addAllNodeLabels(instance.nodeLabels());
                    bits |= 0x400L;
                }
                if ((bits & 0x800L) == 0L) {
                    this.addAllRelationshipTypes(instance.relationshipTypes());
                    bits |= 0x800L;
                }
                if ((bits & 0x1000L) == 0L) {
                    this.configKeys(instance.configKeys());
                    bits |= 0x1000L;
                }
                if ((bits & 0x2000L) == 0L) {
                    this.mutateProperty(instance.mutateProperty());
                    bits |= 0x2000L;
                }
                this.hubProperty(instance.hubProperty());
            }
            if (object instanceof BaseConfig) {
                instance = (BaseConfig)object;
                if ((bits & 0x100L) == 0L) {
                    this.logProgress(instance.logProgress());
                    bits |= 0x100L;
                }
                if ((bits & 0x200L) == 0L) {
                    this.sudo(instance.sudo());
                    bits |= 0x200L;
                }
                if ((bits & 2L) == 0L) {
                    usernameOverrideOptional = instance.usernameOverride();
                    if (usernameOverrideOptional.isPresent()) {
                        this.usernameOverride(usernameOverrideOptional);
                    }
                    bits |= 2L;
                }
                if ((bits & 0x1000L) == 0L) {
                    this.configKeys(instance.configKeys());
                    bits |= 0x1000L;
                }
            }
            if (object instanceof PregelConfig) {
                instance = (PregelConfig)object;
                if ((bits & 0x20L) == 0L) {
                    this.minBatchSize(instance.minBatchSize());
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    this.jobId(instance.jobId());
                    bits |= 0x40L;
                }
                if ((bits & 2L) == 0L) {
                    usernameOverrideOptional = instance.usernameOverride();
                    if (usernameOverrideOptional.isPresent()) {
                        this.usernameOverride(usernameOverrideOptional);
                    }
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    relationshipWeightPropertyOptional = instance.relationshipWeightProperty();
                    if (relationshipWeightPropertyOptional.isPresent()) {
                        this.relationshipWeightProperty(relationshipWeightPropertyOptional);
                    }
                    bits |= 4L;
                }
                if ((bits & 0x100L) == 0L) {
                    this.logProgress(instance.logProgress());
                    bits |= 0x100L;
                }
                if ((bits & 0x200L) == 0L) {
                    this.sudo(instance.sudo());
                    bits |= 0x200L;
                }
                if ((bits & 0x400L) == 0L) {
                    this.addAllNodeLabels(instance.nodeLabels());
                    bits |= 0x400L;
                }
                if ((bits & 0x800L) == 0L) {
                    this.addAllRelationshipTypes(instance.relationshipTypes());
                    bits |= 0x800L;
                }
                if ((bits & 0x1000L) == 0L) {
                    this.configKeys(instance.configKeys());
                    bits |= 0x1000L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.concurrency(instance.concurrency());
                    bits |= 0x10L;
                }
            }
            if (object instanceof AlgoBaseConfig) {
                instance = (AlgoBaseConfig)object;
                if ((bits & 0x20L) == 0L) {
                    this.minBatchSize(instance.minBatchSize());
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    this.jobId(instance.jobId());
                    bits |= 0x40L;
                }
                if ((bits & 2L) == 0L) {
                    usernameOverrideOptional = instance.usernameOverride();
                    if (usernameOverrideOptional.isPresent()) {
                        this.usernameOverride(usernameOverrideOptional);
                    }
                    bits |= 2L;
                }
                if ((bits & 0x100L) == 0L) {
                    this.logProgress(instance.logProgress());
                    bits |= 0x100L;
                }
                if ((bits & 0x200L) == 0L) {
                    this.sudo(instance.sudo());
                    bits |= 0x200L;
                }
                if ((bits & 0x400L) == 0L) {
                    this.addAllNodeLabels(instance.nodeLabels());
                    bits |= 0x400L;
                }
                if ((bits & 0x800L) == 0L) {
                    this.addAllRelationshipTypes(instance.relationshipTypes());
                    bits |= 0x800L;
                }
                if ((bits & 0x1000L) == 0L) {
                    this.configKeys(instance.configKeys());
                    bits |= 0x1000L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.concurrency(instance.concurrency());
                    bits |= 0x10L;
                }
            }
            if (object instanceof MutateNodePropertyConfig) {
                instance = (MutateNodePropertyConfig)object;
                if ((bits & 0x20L) == 0L) {
                    this.minBatchSize(instance.minBatchSize());
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    this.jobId(instance.jobId());
                    bits |= 0x40L;
                }
                if ((bits & 2L) == 0L) {
                    usernameOverrideOptional = instance.usernameOverride();
                    if (usernameOverrideOptional.isPresent()) {
                        this.usernameOverride(usernameOverrideOptional);
                    }
                    bits |= 2L;
                }
                if ((bits & 0x100L) == 0L) {
                    this.logProgress(instance.logProgress());
                    bits |= 0x100L;
                }
                if ((bits & 0x200L) == 0L) {
                    this.sudo(instance.sudo());
                    bits |= 0x200L;
                }
                if ((bits & 0x400L) == 0L) {
                    this.addAllNodeLabels(instance.nodeLabels());
                    bits |= 0x400L;
                }
                if ((bits & 0x800L) == 0L) {
                    this.addAllRelationshipTypes(instance.relationshipTypes());
                    bits |= 0x800L;
                }
                if ((bits & 0x1000L) == 0L) {
                    this.configKeys(instance.configKeys());
                    bits |= 0x1000L;
                }
                if ((bits & 0x2000L) == 0L) {
                    this.mutateProperty(instance.mutateProperty());
                    bits |= 0x2000L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.concurrency(instance.concurrency());
                    bits |= 0x10L;
                }
            }
        }

        public final Builder usernameOverride(@Nullable String usernameOverride) {
            this.usernameOverride = usernameOverride;
            return this;
        }

        public final Builder usernameOverride(Optional<String> usernameOverride) {
            this.usernameOverride = usernameOverride.orElse(null);
            return this;
        }

        public final Builder sudo(boolean sudo) {
            this.sudo = sudo;
            this.optBits |= 1L;
            return this;
        }

        public final Builder logProgress(boolean logProgress) {
            this.logProgress = logProgress;
            this.optBits |= 2L;
            return this;
        }

        public final Builder configKeys(Collection<String> configKeys) {
            this.configKeys = Objects.requireNonNull(configKeys, "configKeys");
            return this;
        }

        public final Builder concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.optBits |= 4L;
            return this;
        }

        public final Builder minBatchSize(int minBatchSize) {
            this.minBatchSize = minBatchSize;
            this.optBits |= 8L;
            return this;
        }

        public final Builder jobId(JobId jobId) {
            this.jobId = Objects.requireNonNull(jobId, "jobId");
            return this;
        }

        public final Builder addRelationshipType(String element) {
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder addRelationshipTypes(String ... elements) {
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            }
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder relationshipTypes(Iterable<String> elements) {
            this.relationshipTypes = new ArrayList<String>();
            return this.addAllRelationshipTypes(elements);
        }

        public final Builder addAllRelationshipTypes(Iterable<String> elements) {
            Objects.requireNonNull(elements, "relationshipTypes element");
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            }
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder addNodeLabel(String element) {
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder addNodeLabels(String ... elements) {
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            }
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder nodeLabels(Iterable<String> elements) {
            this.nodeLabels = new ArrayList<String>();
            return this.addAllNodeLabels(elements);
        }

        public final Builder addAllNodeLabels(Iterable<String> elements) {
            Objects.requireNonNull(elements, "nodeLabels element");
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            }
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder relationshipWeightProperty(@Nullable String relationshipWeightProperty) {
            this.relationshipWeightProperty = relationshipWeightProperty;
            return this;
        }

        public final Builder relationshipWeightProperty(Optional<String> relationshipWeightProperty) {
            this.relationshipWeightProperty = relationshipWeightProperty.orElse(null);
            return this;
        }

        public final Builder writeConcurrency(int writeConcurrency) {
            this.writeConcurrency = writeConcurrency;
            this.optBits |= 0x40L;
            return this;
        }

        public final Builder arrowConnectionInfo(@Nullable WriteConfig.ArrowConnectionInfo arrowConnectionInfo) {
            this.arrowConnectionInfo = arrowConnectionInfo;
            return this;
        }

        public final Builder arrowConnectionInfo(Optional<? extends WriteConfig.ArrowConnectionInfo> arrowConnectionInfo) {
            this.arrowConnectionInfo = arrowConnectionInfo.orElse(null);
            return this;
        }

        public final Builder writeProperty(String writeProperty) {
            this.writeProperty = Objects.requireNonNull(writeProperty, "writeProperty");
            return this;
        }

        public final Builder mutateProperty(String mutateProperty) {
            this.mutateProperty = Objects.requireNonNull(mutateProperty, "mutateProperty");
            return this;
        }

        public final Builder hitsIterations(int hitsIterations) {
            this.hitsIterations = hitsIterations;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder hubProperty(String hubProperty) {
            this.hubProperty = Objects.requireNonNull(hubProperty, "hubProperty");
            return this;
        }

        public final Builder authProperty(String authProperty) {
            this.authProperty = Objects.requireNonNull(authProperty, "authProperty");
            return this;
        }

        public Builder clear() {
            this.initBits = 1L;
            this.optBits = 0L;
            this.usernameOverride = null;
            this.sudo = false;
            this.logProgress = false;
            this.configKeys = null;
            this.concurrency = 0;
            this.minBatchSize = 0;
            this.jobId = null;
            if (this.relationshipTypes != null) {
                this.relationshipTypes.clear();
            }
            if (this.nodeLabels != null) {
                this.nodeLabels.clear();
            }
            this.relationshipWeightProperty = null;
            this.writeConcurrency = 0;
            this.arrowConnectionInfo = null;
            this.writeProperty = null;
            this.mutateProperty = null;
            this.hitsIterations = 0;
            this.hubProperty = null;
            this.authProperty = null;
            return this;
        }

        public Hits.HitsConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableHitsConfig.validate(new ImmutableHitsConfig(this));
        }

        private boolean sudoIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean logProgressIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean concurrencyIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean minBatchSizeIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean relationshipTypesIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean nodeLabelsIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private boolean writeConcurrencyIsSet() {
            return (this.optBits & 0x40L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("hitsIterations");
            }
            return "Cannot build HitsConfig, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="Hits.HitsConfig", generator="Immutables")
    private final class InitShim {
        private byte sudoBuildStage = 0;
        private boolean sudo;
        private byte logProgressBuildStage = 0;
        private boolean logProgress;
        private byte configKeysBuildStage = 0;
        private Collection<String> configKeys;
        private byte toMapBuildStage = 0;
        private Map<String, Object> toMap;
        private byte concurrencyBuildStage = 0;
        private int concurrency;
        private byte minBatchSizeBuildStage = 0;
        private int minBatchSize;
        private byte jobIdBuildStage = 0;
        private JobId jobId;
        private byte relationshipTypesBuildStage = 0;
        private List<String> relationshipTypes;
        private byte nodeLabelsBuildStage = 0;
        private List<String> nodeLabels;
        private byte hasRelationshipWeightPropertyBuildStage = 0;
        private boolean hasRelationshipWeightProperty;
        private byte useForkJoinBuildStage = 0;
        private boolean useForkJoin;
        private byte writeConcurrencyBuildStage = 0;
        private int writeConcurrency;
        private byte writePropertyBuildStage = 0;
        private String writeProperty;
        private byte mutatePropertyBuildStage = 0;
        private String mutateProperty;
        private byte maxIterationsBuildStage = 0;
        private int maxIterations;
        private byte isAsynchronousBuildStage = 0;
        private boolean isAsynchronous;
        private byte hubPropertyBuildStage = 0;
        private String hubProperty;
        private byte authPropertyBuildStage = 0;
        private String authProperty;

        private InitShim() {
        }

        boolean sudo() {
            if (this.sudoBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sudoBuildStage == 0) {
                this.sudoBuildStage = (byte)-1;
                this.sudo = ImmutableHitsConfig.this.sudoInitialize();
                this.sudoBuildStage = 1;
            }
            return this.sudo;
        }

        void sudo(boolean sudo) {
            this.sudo = sudo;
            this.sudoBuildStage = 1;
        }

        boolean logProgress() {
            if (this.logProgressBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.logProgressBuildStage == 0) {
                this.logProgressBuildStage = (byte)-1;
                this.logProgress = ImmutableHitsConfig.this.logProgressInitialize();
                this.logProgressBuildStage = 1;
            }
            return this.logProgress;
        }

        void logProgress(boolean logProgress) {
            this.logProgress = logProgress;
            this.logProgressBuildStage = 1;
        }

        Collection<String> configKeys() {
            if (this.configKeysBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.configKeysBuildStage == 0) {
                this.configKeysBuildStage = (byte)-1;
                this.configKeys = Objects.requireNonNull(ImmutableHitsConfig.this.configKeysInitialize(), "configKeys");
                this.configKeysBuildStage = 1;
            }
            return this.configKeys;
        }

        void configKeys(Collection<String> configKeys) {
            this.configKeys = configKeys;
            this.configKeysBuildStage = 1;
        }

        Map<String, Object> toMap() {
            if (this.toMapBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.toMapBuildStage == 0) {
                this.toMapBuildStage = (byte)-1;
                this.toMap = Objects.requireNonNull(ImmutableHitsConfig.this.toMapInitialize(), "toMap");
                this.toMapBuildStage = 1;
            }
            return this.toMap;
        }

        int concurrency() {
            if (this.concurrencyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.concurrencyBuildStage == 0) {
                this.concurrencyBuildStage = (byte)-1;
                this.concurrency = ImmutableHitsConfig.this.concurrencyInitialize();
                this.concurrencyBuildStage = 1;
            }
            return this.concurrency;
        }

        void concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.concurrencyBuildStage = 1;
        }

        int minBatchSize() {
            if (this.minBatchSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.minBatchSizeBuildStage == 0) {
                this.minBatchSizeBuildStage = (byte)-1;
                this.minBatchSize = ImmutableHitsConfig.this.minBatchSizeInitialize();
                this.minBatchSizeBuildStage = 1;
            }
            return this.minBatchSize;
        }

        void minBatchSize(int minBatchSize) {
            this.minBatchSize = minBatchSize;
            this.minBatchSizeBuildStage = 1;
        }

        JobId jobId() {
            if (this.jobIdBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.jobIdBuildStage == 0) {
                this.jobIdBuildStage = (byte)-1;
                this.jobId = Objects.requireNonNull(ImmutableHitsConfig.this.jobIdInitialize(), "jobId");
                this.jobIdBuildStage = 1;
            }
            return this.jobId;
        }

        void jobId(JobId jobId) {
            this.jobId = jobId;
            this.jobIdBuildStage = 1;
        }

        List<String> relationshipTypes() {
            if (this.relationshipTypesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.relationshipTypesBuildStage == 0) {
                this.relationshipTypesBuildStage = (byte)-1;
                this.relationshipTypes = ImmutableHitsConfig.createUnmodifiableList(false, ImmutableHitsConfig.createSafeList(ImmutableHitsConfig.this.relationshipTypesInitialize(), true, false));
                this.relationshipTypesBuildStage = 1;
            }
            return this.relationshipTypes;
        }

        void relationshipTypes(List<String> relationshipTypes) {
            this.relationshipTypes = relationshipTypes;
            this.relationshipTypesBuildStage = 1;
        }

        List<String> nodeLabels() {
            if (this.nodeLabelsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.nodeLabelsBuildStage == 0) {
                this.nodeLabelsBuildStage = (byte)-1;
                this.nodeLabels = ImmutableHitsConfig.createUnmodifiableList(false, ImmutableHitsConfig.createSafeList(ImmutableHitsConfig.this.nodeLabelsInitialize(), true, false));
                this.nodeLabelsBuildStage = 1;
            }
            return this.nodeLabels;
        }

        void nodeLabels(List<String> nodeLabels) {
            this.nodeLabels = nodeLabels;
            this.nodeLabelsBuildStage = 1;
        }

        boolean hasRelationshipWeightProperty() {
            if (this.hasRelationshipWeightPropertyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hasRelationshipWeightPropertyBuildStage == 0) {
                this.hasRelationshipWeightPropertyBuildStage = (byte)-1;
                this.hasRelationshipWeightProperty = ImmutableHitsConfig.this.hasRelationshipWeightPropertyInitialize();
                this.hasRelationshipWeightPropertyBuildStage = 1;
            }
            return this.hasRelationshipWeightProperty;
        }

        boolean useForkJoin() {
            if (this.useForkJoinBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.useForkJoinBuildStage == 0) {
                this.useForkJoinBuildStage = (byte)-1;
                this.useForkJoin = ImmutableHitsConfig.this.useForkJoinInitialize();
                this.useForkJoinBuildStage = 1;
            }
            return this.useForkJoin;
        }

        int writeConcurrency() {
            if (this.writeConcurrencyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.writeConcurrencyBuildStage == 0) {
                this.writeConcurrencyBuildStage = (byte)-1;
                this.writeConcurrency = ImmutableHitsConfig.this.writeConcurrencyInitialize();
                this.writeConcurrencyBuildStage = 1;
            }
            return this.writeConcurrency;
        }

        void writeConcurrency(int writeConcurrency) {
            this.writeConcurrency = writeConcurrency;
            this.writeConcurrencyBuildStage = 1;
        }

        String writeProperty() {
            if (this.writePropertyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.writePropertyBuildStage == 0) {
                this.writePropertyBuildStage = (byte)-1;
                this.writeProperty = Objects.requireNonNull(ImmutableHitsConfig.this.writePropertyInitialize(), "writeProperty");
                this.writePropertyBuildStage = 1;
            }
            return this.writeProperty;
        }

        void writeProperty(String writeProperty) {
            this.writeProperty = writeProperty;
            this.writePropertyBuildStage = 1;
        }

        String mutateProperty() {
            if (this.mutatePropertyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.mutatePropertyBuildStage == 0) {
                this.mutatePropertyBuildStage = (byte)-1;
                this.mutateProperty = Objects.requireNonNull(ImmutableHitsConfig.this.mutatePropertyInitialize(), "mutateProperty");
                this.mutatePropertyBuildStage = 1;
            }
            return this.mutateProperty;
        }

        void mutateProperty(String mutateProperty) {
            this.mutateProperty = mutateProperty;
            this.mutatePropertyBuildStage = 1;
        }

        int maxIterations() {
            if (this.maxIterationsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.maxIterationsBuildStage == 0) {
                this.maxIterationsBuildStage = (byte)-1;
                this.maxIterations = ImmutableHitsConfig.this.maxIterationsInitialize();
                this.maxIterationsBuildStage = 1;
            }
            return this.maxIterations;
        }

        boolean isAsynchronous() {
            if (this.isAsynchronousBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isAsynchronousBuildStage == 0) {
                this.isAsynchronousBuildStage = (byte)-1;
                this.isAsynchronous = ImmutableHitsConfig.this.isAsynchronousInitialize();
                this.isAsynchronousBuildStage = 1;
            }
            return this.isAsynchronous;
        }

        String hubProperty() {
            if (this.hubPropertyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hubPropertyBuildStage == 0) {
                this.hubPropertyBuildStage = (byte)-1;
                this.hubProperty = Objects.requireNonNull(ImmutableHitsConfig.this.hubPropertyInitialize(), "hubProperty");
                this.hubPropertyBuildStage = 1;
            }
            return this.hubProperty;
        }

        void hubProperty(String hubProperty) {
            this.hubProperty = hubProperty;
            this.hubPropertyBuildStage = 1;
        }

        String authProperty() {
            if (this.authPropertyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.authPropertyBuildStage == 0) {
                this.authPropertyBuildStage = (byte)-1;
                this.authProperty = Objects.requireNonNull(ImmutableHitsConfig.this.authPropertyInitialize(), "authProperty");
                this.authPropertyBuildStage = 1;
            }
            return this.authProperty;
        }

        void authProperty(String authProperty) {
            this.authProperty = authProperty;
            this.authPropertyBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.sudoBuildStage == -1) {
                attributes.add("sudo");
            }
            if (this.logProgressBuildStage == -1) {
                attributes.add("logProgress");
            }
            if (this.configKeysBuildStage == -1) {
                attributes.add("configKeys");
            }
            if (this.toMapBuildStage == -1) {
                attributes.add("toMap");
            }
            if (this.concurrencyBuildStage == -1) {
                attributes.add("concurrency");
            }
            if (this.minBatchSizeBuildStage == -1) {
                attributes.add("minBatchSize");
            }
            if (this.jobIdBuildStage == -1) {
                attributes.add("jobId");
            }
            if (this.relationshipTypesBuildStage == -1) {
                attributes.add("relationshipTypes");
            }
            if (this.nodeLabelsBuildStage == -1) {
                attributes.add("nodeLabels");
            }
            if (this.hasRelationshipWeightPropertyBuildStage == -1) {
                attributes.add("hasRelationshipWeightProperty");
            }
            if (this.useForkJoinBuildStage == -1) {
                attributes.add("useForkJoin");
            }
            if (this.writeConcurrencyBuildStage == -1) {
                attributes.add("writeConcurrency");
            }
            if (this.writePropertyBuildStage == -1) {
                attributes.add("writeProperty");
            }
            if (this.mutatePropertyBuildStage == -1) {
                attributes.add("mutateProperty");
            }
            if (this.maxIterationsBuildStage == -1) {
                attributes.add("maxIterations");
            }
            if (this.isAsynchronousBuildStage == -1) {
                attributes.add("isAsynchronous");
            }
            if (this.hubPropertyBuildStage == -1) {
                attributes.add("hubProperty");
            }
            if (this.authPropertyBuildStage == -1) {
                attributes.add("authProperty");
            }
            return "Cannot build HitsConfig, attribute initializers form cycle " + attributes;
        }
    }
}

