/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.pregel;

import java.util.concurrent.atomic.DoubleAdder;
import org.immutables.value.Value;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.annotation.Configuration;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.api.nodeproperties.ValueType;
import org.neo4j.gds.beta.pregel.BidirectionalPregelComputation;
import org.neo4j.gds.beta.pregel.Messages;
import org.neo4j.gds.beta.pregel.Partitioning;
import org.neo4j.gds.beta.pregel.PregelProcedureConfig;
import org.neo4j.gds.beta.pregel.PregelSchema;
import org.neo4j.gds.beta.pregel.annotation.PregelProcedure;
import org.neo4j.gds.beta.pregel.context.ComputeContext;
import org.neo4j.gds.beta.pregel.context.InitContext;
import org.neo4j.gds.beta.pregel.context.MasterComputeContext;
import org.neo4j.gds.core.CypherMapAccess;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.StringIdentifierValidations;
import org.neo4j.gds.pregel.HitsConfigImpl;

@PregelProcedure(name="gds.alpha.hits", description="Hyperlink-Induced Topic Search (HITS) is a link analysis algorithm that rates nodes")
public class Hits
implements BidirectionalPregelComputation<HitsConfig> {
    private final DoubleAdder globalNorm = new DoubleAdder();
    private HitsState state = HitsState.INIT;

    public PregelSchema schema(HitsConfig config) {
        return new PregelSchema.Builder().add(config.authProperty(), ValueType.DOUBLE).add(config.hubProperty(), ValueType.DOUBLE).build();
    }

    public void init(InitContext.BidirectionalInitContext<HitsConfig> context) {
        context.setNodeValue(((HitsConfig)context.config()).hubProperty(), 1.0);
        context.setNodeValue(((HitsConfig)context.config()).authProperty(), 1.0);
    }

    public void compute(ComputeContext.BidirectionalComputeContext<HitsConfig> context, Messages messages) {
        switch (this.state) {
            case INIT: {
                double auth = context.incomingDegree();
                context.setNodeValue(((HitsConfig)context.config()).authProperty(), auth);
                this.updateGlobalNorm(auth);
                break;
            }
            case CALCULATE_AUTHS: {
                this.calculateValue(context, messages, ((HitsConfig)context.config()).authProperty());
                break;
            }
            case NORMALIZE_AUTHS: {
                this.normalizeAuthValue(context);
                break;
            }
            case CALCULATE_HUBS: {
                this.calculateValue(context, messages, ((HitsConfig)context.config()).hubProperty());
                break;
            }
            case NORMALIZE_HUBS: {
                this.normalizeHubValue(context);
            }
        }
    }

    public boolean masterCompute(MasterComputeContext<HitsConfig> context) {
        if (this.state == HitsState.INIT || this.state == HitsState.CALCULATE_AUTHS || this.state == HitsState.CALCULATE_HUBS) {
            double norm = this.globalNorm.sumThenReset();
            this.globalNorm.add(Math.sqrt(norm));
        } else if (this.state == HitsState.NORMALIZE_AUTHS || this.state == HitsState.NORMALIZE_HUBS) {
            this.globalNorm.reset();
        }
        this.state = this.state.advance();
        return false;
    }

    private void calculateValue(ComputeContext.BidirectionalComputeContext<HitsConfig> context, Messages messages, String authProperty) {
        double auth = 0.0;
        for (Double message : messages) {
            auth += message.doubleValue();
        }
        context.setNodeValue(authProperty, auth);
        this.updateGlobalNorm(auth);
    }

    private void normalizeHubValue(ComputeContext.BidirectionalComputeContext<HitsConfig> context) {
        double normalizedValue = this.normalize(context, ((HitsConfig)context.config()).hubProperty());
        context.sendToNeighbors(normalizedValue);
    }

    private void normalizeAuthValue(ComputeContext.BidirectionalComputeContext<HitsConfig> context) {
        double normalizedValue = this.normalize(context, ((HitsConfig)context.config()).authProperty());
        context.sendToIncomingNeighbors(normalizedValue);
    }

    private void updateGlobalNorm(double value) {
        this.globalNorm.add(Math.pow(value, 2.0));
    }

    private double normalize(ComputeContext.BidirectionalComputeContext<HitsConfig> context, String property) {
        double value = context.doubleNodeValue(property);
        double norm = this.globalNorm.sum();
        double normalizedValue = value / norm;
        context.setNodeValue(property, normalizedValue);
        return normalizedValue;
    }

    private static enum HitsState {
        INIT{

            @Override
            HitsState advance() {
                return NORMALIZE_AUTHS;
            }
        }
        ,
        CALCULATE_AUTHS{

            @Override
            HitsState advance() {
                return NORMALIZE_AUTHS;
            }
        }
        ,
        NORMALIZE_AUTHS{

            @Override
            HitsState advance() {
                return CALCULATE_HUBS;
            }
        }
        ,
        CALCULATE_HUBS{

            @Override
            public HitsState advance() {
                return NORMALIZE_HUBS;
            }
        }
        ,
        NORMALIZE_HUBS{

            @Override
            HitsState advance() {
                return CALCULATE_AUTHS;
            }
        };


        abstract HitsState advance();
    }

    @ValueClass
    @Configuration
    public static interface HitsConfig
    extends PregelProcedureConfig {
        public int hitsIterations();

        @Value.Derived
        @Configuration.Ignore
        default public int maxIterations() {
            return this.hitsIterations() * 4;
        }

        @Configuration.Ignore
        @Value.Derived
        default public boolean isAsynchronous() {
            return false;
        }

        @Value.Default
        @Configuration.ConvertWith(method="validateHubProperty")
        default public String hubProperty() {
            return "hub";
        }

        @Value.Default
        @Configuration.ConvertWith(method="validateAuthProperty")
        default public String authProperty() {
            return "auth";
        }

        default public Partitioning partitioning() {
            return Partitioning.AUTO;
        }

        @Nullable
        public static String validateHubProperty(String input) {
            return StringIdentifierValidations.validateNoWhiteCharacter((String)input, (String)"hubProperty");
        }

        @Nullable
        public static String validateAuthProperty(String input) {
            return StringIdentifierValidations.validateNoWhiteCharacter((String)input, (String)"authProperty");
        }

        public static HitsConfig of(CypherMapWrapper userConfig) {
            return new HitsConfigImpl((CypherMapAccess)userConfig);
        }
    }
}

