/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.walking;

import java.util.stream.Stream;
import org.neo4j.gds.MutateComputationResultConsumer;
import org.neo4j.gds.beta.walking.CollapsePath;
import org.neo4j.gds.beta.walking.CollapsePathAlgorithmFactory;
import org.neo4j.gds.beta.walking.CollapsePathConfig;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.loading.SingleTypeRelationships;
import org.neo4j.gds.executor.AlgorithmSpec;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ComputationResultConsumer;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.executor.NewConfigFunction;
import org.neo4j.gds.result.AbstractResultBuilder;
import org.neo4j.gds.walking.MutateResult;

@GdsCallable(name="gds.beta.collapsePath.mutate", description="Collapse Path algorithm is a traversal algorithm capable of creating relationships between the start and end nodes of a traversal", executionMode=ExecutionMode.MUTATE_RELATIONSHIP)
public class CollapsePathMutateSpec
implements AlgorithmSpec<CollapsePath, SingleTypeRelationships, CollapsePathConfig, Stream<MutateResult>, CollapsePathAlgorithmFactory> {
    public String name() {
        return "CollapsePath";
    }

    public CollapsePathAlgorithmFactory algorithmFactory() {
        return new CollapsePathAlgorithmFactory();
    }

    public NewConfigFunction<CollapsePathConfig> newConfigFunction() {
        return (username, config) -> CollapsePathConfig.of((CypherMapWrapper)config);
    }

    public ComputationResultConsumer<CollapsePath, SingleTypeRelationships, CollapsePathConfig, Stream<MutateResult>> computationResultConsumer() {
        return new MutateComputationResultConsumer<CollapsePath, SingleTypeRelationships, CollapsePathConfig, MutateResult>(this::resultBuilder){

            protected void updateGraphStore(AbstractResultBuilder<?> resultBuilder, ComputationResult<CollapsePath, SingleTypeRelationships, CollapsePathConfig> computationResult, ExecutionContext executionContext) {
                computationResult.graphStore().addRelationshipType((SingleTypeRelationships)computationResult.result());
                resultBuilder.withRelationshipsWritten(((SingleTypeRelationships)computationResult.result()).topology().elementCount());
            }
        };
    }

    private AbstractResultBuilder<MutateResult> resultBuilder(ComputationResult<CollapsePath, SingleTypeRelationships, CollapsePathConfig> computeResult, ExecutionContext executionContext) {
        MutateResult.Builder builder = new MutateResult.Builder();
        return builder;
    }
}

