/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.scc;

import org.neo4j.gds.api.ProcedureReturnColumns;
import org.neo4j.gds.config.WritePropertyConfig;
import org.neo4j.gds.result.AbstractCommunityResultBuilder;

public class WriteResult {
    public final long preProcessingMillis;
    public final long computeMillis;
    public final long writeMillis;
    public final long postProcessingMillis;
    public final long nodes;
    public final long communityCount;
    public final long setCount;
    public final long minSetSize;
    public final long maxSetSize;
    public final long p1;
    public final long p5;
    public final long p10;
    public final long p25;
    public final long p50;
    public final long p75;
    public final long p90;
    public final long p95;
    public final long p99;
    public final long p100;
    public final String writeProperty;

    public WriteResult(long preProcessingMillis, long computeMillis, long postProcessingMillis, long writeMillis, long nodes, long communityCount, long p100, long p99, long p95, long p90, long p75, long p50, long p25, long p10, long p5, long p1, long minSetSize, long maxSetSize, String writeProperty) {
        this.preProcessingMillis = preProcessingMillis;
        this.computeMillis = computeMillis;
        this.postProcessingMillis = postProcessingMillis;
        this.writeMillis = writeMillis;
        this.nodes = nodes;
        this.setCount = this.communityCount = communityCount;
        this.p100 = p100;
        this.p99 = p99;
        this.p95 = p95;
        this.p90 = p90;
        this.p75 = p75;
        this.p50 = p50;
        this.p25 = p25;
        this.p10 = p10;
        this.p5 = p5;
        this.p1 = p1;
        this.minSetSize = minSetSize;
        this.maxSetSize = maxSetSize;
        this.writeProperty = writeProperty;
    }

    static class Builder
    extends AbstractCommunityResultBuilder<WriteResult> {
        Builder(ProcedureReturnColumns returnColumns, int concurrency) {
            super(returnColumns, concurrency);
        }

        public WriteResult buildResult() {
            return new WriteResult(this.preProcessingMillis, this.computeMillis, this.writeMillis, this.postProcessingDuration, this.nodeCount, this.maybeCommunityCount.orElse(0L), this.maybeCommunityHistogram.map(h -> h.getValueAtPercentile(100.0)).orElse(0L), this.maybeCommunityHistogram.map(h -> h.getValueAtPercentile(99.0)).orElse(0L), this.maybeCommunityHistogram.map(h -> h.getValueAtPercentile(95.0)).orElse(0L), this.maybeCommunityHistogram.map(h -> h.getValueAtPercentile(90.0)).orElse(0L), this.maybeCommunityHistogram.map(h -> h.getValueAtPercentile(75.0)).orElse(0L), this.maybeCommunityHistogram.map(h -> h.getValueAtPercentile(50.0)).orElse(0L), this.maybeCommunityHistogram.map(h -> h.getValueAtPercentile(25.0)).orElse(0L), this.maybeCommunityHistogram.map(h -> h.getValueAtPercentile(10.0)).orElse(0L), this.maybeCommunityHistogram.map(h -> h.getValueAtPercentile(5.0)).orElse(0L), this.maybeCommunityHistogram.map(h -> h.getValueAtPercentile(1.0)).orElse(0L), this.maybeCommunityHistogram.map(h -> h.getMinNonZeroValue()).orElse(0L), this.maybeCommunityHistogram.map(h -> h.getMaxValue()).orElse(0L), this.config instanceof WritePropertyConfig ? ((WritePropertyConfig)this.config).writeProperty() : "");
        }

        public Builder buildHistogram(boolean buildHistogram) {
            this.buildHistogram = buildHistogram;
            return this;
        }

        public Builder buildCommunityCount(boolean buildCommunityCount) {
            this.buildCommunityCount = buildCommunityCount;
            return this;
        }
    }
}

