/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.scc;

import java.util.stream.Stream;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.api.properties.nodes.LongNodePropertyValues;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.concurrency.Pools;
import org.neo4j.gds.core.utils.ProgressTimer;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.utils.progress.tasks.TaskProgressTracker;
import org.neo4j.gds.core.write.NodePropertyExporter;
import org.neo4j.gds.executor.AlgorithmSpec;
import org.neo4j.gds.executor.ComputationResultConsumer;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.executor.NewConfigFunction;
import org.neo4j.gds.impl.scc.Scc;
import org.neo4j.gds.impl.scc.SccAlgorithmFactory;
import org.neo4j.gds.impl.scc.SccWriteConfig;
import org.neo4j.gds.result.AbstractResultBuilder;
import org.neo4j.gds.scc.WriteResult;

@GdsCallable(name="gds.alpha.scc.write", description="The SCC algorithm finds sets of connected nodes in an directed graph, where all nodes in the same set form a connected component.", executionMode=ExecutionMode.WRITE_NODE_PROPERTY)
public class SccWriteSpec
implements AlgorithmSpec<Scc, HugeLongArray, SccWriteConfig, Stream<WriteResult>, SccAlgorithmFactory<SccWriteConfig>> {
    public String name() {
        return "SccWrite";
    }

    public SccAlgorithmFactory<SccWriteConfig> algorithmFactory() {
        return new SccAlgorithmFactory();
    }

    public NewConfigFunction<SccWriteConfig> newConfigFunction() {
        return (__, config) -> SccWriteConfig.of((CypherMapWrapper)config);
    }

    public ComputationResultConsumer<Scc, HugeLongArray, SccWriteConfig, Stream<WriteResult>> computationResultConsumer() {
        return (computationResult, executionContext) -> {
            Scc algorithm = (Scc)computationResult.algorithm();
            HugeLongArray components = (HugeLongArray)computationResult.result();
            SccWriteConfig config = (SccWriteConfig)computationResult.config();
            Graph graph = computationResult.graph();
            AbstractResultBuilder writeBuilder = new WriteResult.Builder(executionContext.returnColumns(), config.concurrency()).buildCommunityCount(true).buildHistogram(true).withCommunityFunction(components != null ? arg_0 -> ((HugeLongArray)components).get(arg_0) : null).withNodeCount(graph.nodeCount()).withConfig((AlgoBaseConfig)config).withPreProcessingMillis(computationResult.preProcessingMillis()).withComputeMillis(computationResult.computeMillis());
            if (graph.isEmpty()) {
                return Stream.of((WriteResult)writeBuilder.build());
            }
            try (ProgressTimer ignored = ProgressTimer.start(arg_0 -> ((AbstractResultBuilder)writeBuilder).withWriteMillis(arg_0));){
                TaskProgressTracker progressTracker = new TaskProgressTracker(NodePropertyExporter.baseTask((String)"Scc", (long)graph.nodeCount()), executionContext.log(), config.writeConcurrency(), executionContext.taskRegistryFactory());
                NodePropertyExporter exporter = executionContext.nodePropertyExporterBuilder().withIdMap((IdMap)graph).withTerminationFlag(algorithm.getTerminationFlag()).withProgressTracker((ProgressTracker)progressTracker).parallel(Pools.DEFAULT, config.writeConcurrency()).build();
                LongNodePropertyValues properties = components.asNodeProperties();
                exporter.write(config.writeProperty(), (NodePropertyValues)properties);
                writeBuilder.withNodePropertiesWritten(exporter.propertiesWritten());
            }
            return Stream.of((WriteResult)writeBuilder.build());
        };
    }
}

