/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.scc;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.BaseProc;
import org.neo4j.gds.core.write.NodePropertyExporter;
import org.neo4j.gds.core.write.NodePropertyExporterBuilder;
import org.neo4j.gds.executor.AlgorithmSpec;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.executor.ProcedureExecutor;
import org.neo4j.gds.scc.SccWriteSpec;
import org.neo4j.gds.scc.WriteResult;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class SccWriteProc
extends BaseProc {
    @Context
    public NodePropertyExporterBuilder<? extends NodePropertyExporter> nodePropertyExporterBuilder;

    @Procedure(value="gds.alpha.scc.write", mode=Mode.WRITE)
    @Description(value="The SCC algorithm finds sets of connected nodes in an directed graph, where all nodes in the same set form a connected component.")
    public Stream<WriteResult> write(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return (Stream)new ProcedureExecutor((AlgorithmSpec)new SccWriteSpec(), this.executionContext()).compute(graphName, configuration);
    }

    public ExecutionContext executionContext() {
        return super.executionContext().withNodePropertyExporterBuilder(this.nodePropertyExporterBuilder);
    }
}

