/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.scc;

import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.executor.AlgorithmSpec;
import org.neo4j.gds.executor.ComputationResultConsumer;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.executor.NewConfigFunction;
import org.neo4j.gds.impl.scc.Scc;
import org.neo4j.gds.impl.scc.SccAlgorithmFactory;
import org.neo4j.gds.impl.scc.SccStreamConfig;
import org.neo4j.gds.scc.StreamResult;

@GdsCallable(name="gds.alpha.scc.stream", description="The SCC algorithm finds sets of connected nodes in an directed graph, where all nodes in the same set form a connected component.", executionMode=ExecutionMode.STREAM)
public class SccStreamSpec
implements AlgorithmSpec<Scc, HugeLongArray, SccStreamConfig, Stream<StreamResult>, SccAlgorithmFactory<SccStreamConfig>> {
    public String name() {
        return "SccStream";
    }

    public SccAlgorithmFactory<SccStreamConfig> algorithmFactory() {
        return new SccAlgorithmFactory();
    }

    public NewConfigFunction<SccStreamConfig> newConfigFunction() {
        return (__, config) -> SccStreamConfig.of((CypherMapWrapper)config);
    }

    public ComputationResultConsumer<Scc, HugeLongArray, SccStreamConfig, Stream<StreamResult>> computationResultConsumer() {
        return (computationResult, executionContext) -> {
            Graph graph = computationResult.graph();
            HugeLongArray components = (HugeLongArray)computationResult.result();
            if (graph.isEmpty()) {
                return Stream.empty();
            }
            return LongStream.range(0L, graph.nodeCount()).filter(i -> components.get(i) != -1L).mapToObj(i -> new StreamResult(graph.toOriginalNodeId(i), components.get(i)));
        };
    }
}

