/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.influenceMaximization;

import com.carrotsearch.hppc.LongDoubleScatterMap;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.neo4j.gds.WriteNodePropertiesComputationResultConsumer;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.write.NodeProperty;
import org.neo4j.gds.executor.AlgorithmSpec;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ComputationResultConsumer;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.executor.NewConfigFunction;
import org.neo4j.gds.influenceMaximization.CELF;
import org.neo4j.gds.influenceMaximization.CELFAlgorithmFactory;
import org.neo4j.gds.influenceMaximization.CelfNodeProperties;
import org.neo4j.gds.influenceMaximization.InfluenceMaximizationWriteConfig;
import org.neo4j.gds.influenceMaximization.WriteResult;
import org.neo4j.gds.result.AbstractResultBuilder;

@GdsCallable(name="gds.beta.influenceMaximization.celf.write", description="The Cost Effective Lazy Forward (CELF) algorithm aims to find k nodes that maximize the expected spread of influence in the network.", executionMode=ExecutionMode.WRITE_NODE_PROPERTY)
public class CELFWriteSpec
implements AlgorithmSpec<CELF, LongDoubleScatterMap, InfluenceMaximizationWriteConfig, Stream<WriteResult>, CELFAlgorithmFactory<InfluenceMaximizationWriteConfig>> {
    public String name() {
        return "CELFStream";
    }

    public CELFAlgorithmFactory<InfluenceMaximizationWriteConfig> algorithmFactory() {
        return new CELFAlgorithmFactory();
    }

    public NewConfigFunction<InfluenceMaximizationWriteConfig> newConfigFunction() {
        return (__, userInput) -> InfluenceMaximizationWriteConfig.of((CypherMapWrapper)userInput);
    }

    public ComputationResultConsumer<CELF, LongDoubleScatterMap, InfluenceMaximizationWriteConfig, Stream<WriteResult>> computationResultConsumer() {
        return new WriteNodePropertiesComputationResultConsumer(this::resultBuilder, computationResult -> List.of(NodeProperty.of((String)((InfluenceMaximizationWriteConfig)computationResult.config()).writeProperty(), (NodePropertyValues)this.nodePropertyValues((ComputationResult<CELF, LongDoubleScatterMap, InfluenceMaximizationWriteConfig>)computationResult))), this.name());
    }

    private NodePropertyValues nodePropertyValues(ComputationResult<CELF, LongDoubleScatterMap, InfluenceMaximizationWriteConfig> computationResult) {
        LongDoubleScatterMap celfSeedSet = (LongDoubleScatterMap)computationResult.result();
        Graph graph = computationResult.graph();
        return new CelfNodeProperties(celfSeedSet, graph.nodeCount());
    }

    private AbstractResultBuilder<WriteResult> resultBuilder(ComputationResult<CELF, LongDoubleScatterMap, InfluenceMaximizationWriteConfig> computationResult, ExecutionContext context) {
        LongDoubleScatterMap celfSeedSet = (LongDoubleScatterMap)computationResult.result();
        Graph graph = computationResult.graph();
        return WriteResult.builder().withTotalSpread(Arrays.stream(celfSeedSet.values).sum()).withNodeCount(graph.nodeCount()).withComputeMillis(computationResult.computeMillis()).withConfig(computationResult.config());
    }
}

