/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.influenceMaximization;

import com.carrotsearch.hppc.LongDoubleScatterMap;
import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.executor.AlgorithmSpec;
import org.neo4j.gds.executor.ComputationResultConsumer;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.executor.NewConfigFunction;
import org.neo4j.gds.influenceMaximization.CELF;
import org.neo4j.gds.influenceMaximization.CELFAlgorithmFactory;
import org.neo4j.gds.influenceMaximization.InfluenceMaximizationResult;
import org.neo4j.gds.influenceMaximization.InfluenceMaximizationStreamConfig;

@GdsCallable(name="gds.beta.influenceMaximization.celf.stream", description="The Cost Effective Lazy Forward (CELF) algorithm aims to find k nodes that maximize the expected spread of influence in the network.", executionMode=ExecutionMode.STREAM)
public class CELFStreamSpec
implements AlgorithmSpec<CELF, LongDoubleScatterMap, InfluenceMaximizationStreamConfig, Stream<InfluenceMaximizationResult>, CELFAlgorithmFactory<InfluenceMaximizationStreamConfig>> {
    public String name() {
        return "CELFStream";
    }

    public CELFAlgorithmFactory<InfluenceMaximizationStreamConfig> algorithmFactory() {
        return new CELFAlgorithmFactory();
    }

    public NewConfigFunction<InfluenceMaximizationStreamConfig> newConfigFunction() {
        return (__, userInput) -> InfluenceMaximizationStreamConfig.of((CypherMapWrapper)userInput);
    }

    public ComputationResultConsumer<CELF, LongDoubleScatterMap, InfluenceMaximizationStreamConfig, Stream<InfluenceMaximizationResult>> computationResultConsumer() {
        return (computationResult, executionContext) -> {
            LongDoubleScatterMap celfSeedSetMap = (LongDoubleScatterMap)computationResult.result();
            if (celfSeedSetMap == null) {
                return Stream.empty();
            }
            return Optional.ofNullable((CELF)computationResult.algorithm()).map(CELF::resultStream).orElseGet(Stream::empty);
        };
    }
}

