/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.influenceMaximization;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.BaseProc;
import org.neo4j.gds.executor.AlgorithmSpec;
import org.neo4j.gds.executor.MemoryEstimationExecutor;
import org.neo4j.gds.executor.ProcedureExecutor;
import org.neo4j.gds.influenceMaximization.CELFStreamSpec;
import org.neo4j.gds.influenceMaximization.InfluenceMaximizationResult;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class CELFStreamProc
extends BaseProc {
    public static final String DESCRIPTION = "The Cost Effective Lazy Forward (CELF) algorithm aims to find k nodes that maximize the expected spread of influence in the network.";

    @Procedure(name="gds.beta.influenceMaximization.celf.stream", mode=Mode.READ)
    @Description(value="The Cost Effective Lazy Forward (CELF) algorithm aims to find k nodes that maximize the expected spread of influence in the network.")
    public Stream<InfluenceMaximizationResult> stream(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return (Stream)new ProcedureExecutor((AlgorithmSpec)new CELFStreamSpec(), this.executionContext()).compute(graphName, configuration);
    }

    @Procedure(name="gds.beta.influenceMaximization.celf.stream.estimate", mode=Mode.READ)
    @Description(value="The Cost Effective Lazy Forward (CELF) algorithm aims to find k nodes that maximize the expected spread of influence in the network.")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphName") Object graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        CELFStreamSpec streamSpec = new CELFStreamSpec();
        return new MemoryEstimationExecutor((AlgorithmSpec)streamSpec, this.executionContext(), this.transactionContext()).computeEstimate(graphName, configuration);
    }
}

