/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.influenceMaximization;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.BaseProc;
import org.neo4j.gds.executor.AlgorithmSpec;
import org.neo4j.gds.executor.MemoryEstimationExecutor;
import org.neo4j.gds.executor.ProcedureExecutor;
import org.neo4j.gds.influenceMaximization.CELFStatsSpec;
import org.neo4j.gds.influenceMaximization.StatsResult;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class CELFStatsProc
extends BaseProc {
    @Procedure(value="gds.beta.influenceMaximization.celf.stats", mode=Mode.READ)
    @Description(value="Executes the algorithm and returns result statistics without writing the result to Neo4j.")
    public Stream<StatsResult> stats(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return (Stream)new ProcedureExecutor((AlgorithmSpec)new CELFStatsSpec(), this.executionContext()).compute(graphName, configuration);
    }

    @Procedure(name="gds.beta.influenceMaximization.celf.stats.estimate", mode=Mode.READ)
    @Description(value="Returns an estimation of the memory consumption for that procedure.")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphNameOrConfiguration") Object graphNameOrConfiguration, @Name(value="algoConfiguration") Map<String, Object> algoConfiguration) {
        CELFStatsSpec statsSpec = new CELFStatsSpec();
        return new MemoryEstimationExecutor((AlgorithmSpec)statsSpec, this.executionContext(), this.transactionContext()).computeEstimate(graphNameOrConfiguration, algoConfiguration);
    }
}

