/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.conductance;

import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.neo4j.gds.collections.HugeSparseDoubleArray;
import org.neo4j.gds.conductance.StreamResult;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.executor.AlgorithmSpec;
import org.neo4j.gds.executor.ComputationResultConsumer;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.executor.NewConfigFunction;
import org.neo4j.gds.impl.conductance.Conductance;
import org.neo4j.gds.impl.conductance.ConductanceFactory;
import org.neo4j.gds.impl.conductance.ConductanceResult;
import org.neo4j.gds.impl.conductance.ConductanceStreamConfig;

@GdsCallable(name="gds.alpha.conductance.stream", description="Evaluates a division of nodes into communities based on the proportion of relationships that cross community boundaries.", executionMode=ExecutionMode.STREAM)
public class ConductanceStreamSpec
implements AlgorithmSpec<Conductance, ConductanceResult, ConductanceStreamConfig, Stream<StreamResult>, ConductanceFactory<ConductanceStreamConfig>> {
    public String name() {
        return "ConductanceStream";
    }

    public ConductanceFactory<ConductanceStreamConfig> algorithmFactory() {
        return new ConductanceFactory();
    }

    public NewConfigFunction<ConductanceStreamConfig> newConfigFunction() {
        return (username, configuration) -> ConductanceStreamConfig.of((CypherMapWrapper)configuration);
    }

    public ComputationResultConsumer<Conductance, ConductanceResult, ConductanceStreamConfig, Stream<StreamResult>> computationResultConsumer() {
        return (computationResult, executionContext) -> {
            if (computationResult.isGraphEmpty()) {
                return Stream.empty();
            }
            ConductanceResult result = (ConductanceResult)computationResult.result();
            HugeSparseDoubleArray condunctances = result.communityConductances();
            return LongStream.range(0L, condunctances.capacity()).filter(c -> !Double.isNaN(condunctances.get(c))).mapToObj(c -> new StreamResult(c, condunctances.get(c)));
        };
    }
}

