/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.approxmaxkcut;

import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.neo4j.gds.CommunityProcCompanion;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.properties.nodes.LongNodePropertyValues;
import org.neo4j.gds.approxmaxkcut.StreamResult;
import org.neo4j.gds.config.ConcurrencyConfig;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.executor.AlgorithmSpec;
import org.neo4j.gds.executor.ComputationResultConsumer;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.executor.NewConfigFunction;
import org.neo4j.gds.impl.approxmaxkcut.ApproxMaxKCut;
import org.neo4j.gds.impl.approxmaxkcut.ApproxMaxKCutFactory;
import org.neo4j.gds.impl.approxmaxkcut.MaxKCutResult;
import org.neo4j.gds.impl.approxmaxkcut.config.ApproxMaxKCutStreamConfig;

@GdsCallable(name="gds.alpha.maxkcut.stream", description="Approximate Maximum k-cut maps each node into one of k disjoint communities trying to maximize the sum of weights of relationships between these communities.", executionMode=ExecutionMode.MUTATE_NODE_PROPERTY)
public class ApproxMaxKCutStreamSpec
implements AlgorithmSpec<ApproxMaxKCut, MaxKCutResult, ApproxMaxKCutStreamConfig, Stream<StreamResult>, ApproxMaxKCutFactory<ApproxMaxKCutStreamConfig>> {
    public String name() {
        return "ApproxMaxKCutStream";
    }

    public ApproxMaxKCutFactory<ApproxMaxKCutStreamConfig> algorithmFactory() {
        return new ApproxMaxKCutFactory();
    }

    public NewConfigFunction<ApproxMaxKCutStreamConfig> newConfigFunction() {
        return (___, config) -> ApproxMaxKCutStreamConfig.of((CypherMapWrapper)config);
    }

    public ComputationResultConsumer<ApproxMaxKCut, MaxKCutResult, ApproxMaxKCutStreamConfig, Stream<StreamResult>> computationResultConsumer() {
        return (computationResult, executionContext) -> {
            if (computationResult.isGraphEmpty()) {
                return Stream.empty();
            }
            LongNodePropertyValues nodeProperties = CommunityProcCompanion.considerSizeFilter((ConcurrencyConfig)((ApproxMaxKCutStreamConfig)computationResult.config()), (LongNodePropertyValues)((MaxKCutResult)computationResult.result()).asNodeProperties());
            Graph graph = computationResult.graph();
            return LongStream.range(0L, graph.nodeCount()).filter(v -> nodeProperties.hasValue(v)).mapToObj(nodeId -> new StreamResult(graph.toOriginalNodeId(nodeId), nodeProperties.longValue(nodeId)));
        };
    }
}

