/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.approxmaxkcut;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.BaseProc;
import org.neo4j.gds.approxmaxkcut.ApproxMaxKCutStreamSpec;
import org.neo4j.gds.approxmaxkcut.StreamResult;
import org.neo4j.gds.executor.AlgorithmSpec;
import org.neo4j.gds.executor.MemoryEstimationExecutor;
import org.neo4j.gds.executor.ProcedureExecutor;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class ApproxMaxKCutStreamProc
extends BaseProc {
    @Procedure(value="gds.alpha.maxkcut.stream", mode=Mode.READ)
    @Description(value="Approximate Maximum k-cut maps each node into one of k disjoint communities trying to maximize the sum of weights of relationships between these communities.")
    public Stream<StreamResult> stream(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return (Stream)new ProcedureExecutor((AlgorithmSpec)new ApproxMaxKCutStreamSpec(), this.executionContext()).compute(graphName, configuration);
    }

    @Procedure(value="gds.alpha.maxkcut.stream.estimate", mode=Mode.READ)
    @Description(value="Approximate Maximum k-cut maps each node into one of k disjoint communities trying to maximize the sum of weights of relationships between these communities.")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphNameOrConfiguration") Object graphNameOrConfiguration, @Name(value="algoConfiguration") Map<String, Object> algoConfiguration) {
        return new MemoryEstimationExecutor((AlgorithmSpec)new ApproxMaxKCutStreamSpec(), this.executionContext(), this.transactionContext()).computeEstimate(graphNameOrConfiguration, algoConfiguration);
    }
}

