/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.approxmaxkcut;

import java.util.List;
import java.util.stream.Stream;
import org.neo4j.gds.CommunityProcCompanion;
import org.neo4j.gds.MutatePropertyComputationResultConsumer;
import org.neo4j.gds.api.properties.nodes.LongNodePropertyValues;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.approxmaxkcut.MutateResult;
import org.neo4j.gds.config.ConcurrencyConfig;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.write.ImmutableNodeProperty;
import org.neo4j.gds.executor.AlgorithmSpec;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ComputationResultConsumer;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.executor.NewConfigFunction;
import org.neo4j.gds.impl.approxmaxkcut.ApproxMaxKCut;
import org.neo4j.gds.impl.approxmaxkcut.ApproxMaxKCutFactory;
import org.neo4j.gds.impl.approxmaxkcut.MaxKCutResult;
import org.neo4j.gds.impl.approxmaxkcut.config.ApproxMaxKCutMutateConfig;
import org.neo4j.gds.result.AbstractResultBuilder;

@GdsCallable(name="gds.alpha.maxkcut.mutate", description="Approximate Maximum k-cut maps each node into one of k disjoint communities trying to maximize the sum of weights of relationships between these communities.", executionMode=ExecutionMode.MUTATE_NODE_PROPERTY)
public class ApproxMaxKCutMutateSpec
implements AlgorithmSpec<ApproxMaxKCut, MaxKCutResult, ApproxMaxKCutMutateConfig, Stream<MutateResult>, ApproxMaxKCutFactory<ApproxMaxKCutMutateConfig>> {
    public String name() {
        return "ApproxMaxKCutMutate";
    }

    public ApproxMaxKCutFactory<ApproxMaxKCutMutateConfig> algorithmFactory() {
        return new ApproxMaxKCutFactory();
    }

    public NewConfigFunction<ApproxMaxKCutMutateConfig> newConfigFunction() {
        return (___, config) -> ApproxMaxKCutMutateConfig.of((CypherMapWrapper)config);
    }

    public ComputationResultConsumer<ApproxMaxKCut, MaxKCutResult, ApproxMaxKCutMutateConfig, Stream<MutateResult>> computationResultConsumer() {
        return new MutatePropertyComputationResultConsumer(computationResult -> List.of(ImmutableNodeProperty.of((String)((ApproxMaxKCutMutateConfig)computationResult.config()).mutateProperty(), (NodePropertyValues)CommunityProcCompanion.considerSizeFilter((ConcurrencyConfig)((ApproxMaxKCutMutateConfig)computationResult.config()), (LongNodePropertyValues)((MaxKCutResult)computationResult.result()).asNodeProperties()))), this::resultBuilder);
    }

    private AbstractResultBuilder<MutateResult> resultBuilder(ComputationResult<ApproxMaxKCut, MaxKCutResult, ApproxMaxKCutMutateConfig> computationResult, ExecutionContext executionContext) {
        MaxKCutResult result = (MaxKCutResult)computationResult.result();
        MutateResult.Builder builder = new MutateResult.Builder(result.cutCost());
        return builder;
    }
}

