/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.approxmaxkcut;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.BaseProc;
import org.neo4j.gds.approxmaxkcut.ApproxMaxKCutMutateSpec;
import org.neo4j.gds.approxmaxkcut.MutateResult;
import org.neo4j.gds.executor.AlgorithmSpec;
import org.neo4j.gds.executor.MemoryEstimationExecutor;
import org.neo4j.gds.executor.ProcedureExecutor;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class ApproxMaxKCutMutateProc
extends BaseProc {
    @Procedure(value="gds.alpha.maxkcut.mutate", mode=Mode.READ)
    @Description(value="Approximate Maximum k-cut maps each node into one of k disjoint communities trying to maximize the sum of weights of relationships between these communities.")
    public Stream<MutateResult> mutate(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return (Stream)new ProcedureExecutor((AlgorithmSpec)new ApproxMaxKCutMutateSpec(), this.executionContext()).compute(graphName, configuration);
    }

    @Procedure(value="gds.alpha.maxkcut.mutate.estimate", mode=Mode.READ)
    @Description(value="Approximate Maximum k-cut maps each node into one of k disjoint communities trying to maximize the sum of weights of relationships between these communities.")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphNameOrConfiguration") Object graphNameOrConfiguration, @Name(value="algoConfiguration") Map<String, Object> algoConfiguration) {
        return new MemoryEstimationExecutor((AlgorithmSpec)new ApproxMaxKCutMutateSpec(), this.executionContext(), this.transactionContext()).computeEstimate(graphNameOrConfiguration, algoConfiguration);
    }
}

