/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.influenceMaximization;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.BaseProc;
import org.neo4j.gds.executor.AlgorithmSpec;
import org.neo4j.gds.executor.MemoryEstimationExecutor;
import org.neo4j.gds.executor.ProcedureExecutor;
import org.neo4j.gds.influenceMaximization.CELFMutateSpec;
import org.neo4j.gds.influenceMaximization.MutateResult;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class CELFMutateProc
extends BaseProc {
    @Procedure(name="gds.beta.influenceMaximization.celf.mutate", mode=Mode.READ)
    @Description(value="The Cost Effective Lazy Forward (CELF) algorithm aims to find k nodes that maximize the expected spread of influence in the network.")
    public Stream<MutateResult> mutate(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return (Stream)new ProcedureExecutor((AlgorithmSpec)new CELFMutateSpec(), this.executionContext()).compute(graphName, configuration);
    }

    @Procedure(name="gds.beta.influenceMaximization.celf.mutate.estimate", mode=Mode.READ)
    @Description(value="Returns an estimation of the memory consumption for that procedure.")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphNameOrConfiguration") Object graphNameOrConfiguration, @Name(value="algoConfiguration") Map<String, Object> algoConfiguration) {
        CELFMutateSpec mutateSpec = new CELFMutateSpec();
        return new MemoryEstimationExecutor((AlgorithmSpec)mutateSpec, this.executionContext(), this.transactionContext()).computeEstimate(graphNameOrConfiguration, algoConfiguration);
    }
}

