/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.cypher;

import java.util.stream.Stream;
import org.apache.commons.lang3.mutable.MutableLong;
import org.neo4j.common.Edition;
import org.neo4j.dbms.api.DatabaseManagementException;
import org.neo4j.gds.catalog.CatalogProc;
import org.neo4j.gds.compat.StorageEngineProxy;
import org.neo4j.gds.core.utils.ProgressTimer;
import org.neo4j.gds.executor.ProcPreconditions;
import org.neo4j.gds.storageengine.InMemoryDatabaseCreator;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class GraphCreateCypherDbProc
extends CatalogProc {
    private static final String DESCRIPTION = "Creates a database from a GDS graph.";

    @Procedure(name="gds.alpha.create.cypherdb", mode=Mode.READ)
    @Description(value="Creates a database from a GDS graph.")
    public Stream<CreateCypherDbResult> createDb(@Name(value="dbName") String dbName, @Name(value="graphName") String graphName) {
        ProcPreconditions.check();
        this.validateGraphName(graphName);
        CreateCypherDbResult result = (CreateCypherDbResult)this.runWithExceptionLogging("In-memory Cypher database creation failed", () -> {
            GraphCreateCypherDbProc.validateNeo4jEnterpriseEdition(this.databaseService);
            MutableLong createMillis = new MutableLong(0L);
            try (ProgressTimer ignored = ProgressTimer.start(arg_0 -> ((MutableLong)createMillis).setValue(arg_0));){
                InMemoryDatabaseCreator.createDatabase((GraphDatabaseService)this.databaseService, (String)this.username(), (String)graphName, (String)dbName);
            }
            return new CreateCypherDbResult(dbName, graphName, createMillis.getValue());
        });
        return Stream.of(result);
    }

    static void validateNeo4jEnterpriseEdition(GraphDatabaseService databaseService) {
        Edition edition = StorageEngineProxy.dbmsEdition((GraphDatabaseService)databaseService);
        if (edition != Edition.ENTERPRISE) {
            throw new DatabaseManagementException(StringFormatting.formatWithLocale((String)"Requires Neo4j %s version, but found %s", (Object[])new Object[]{Edition.ENTERPRISE, edition}));
        }
    }

    public static class CreateCypherDbResult {
        public final String dbName;
        public final String graphName;
        public final long createMillis;

        public CreateCypherDbResult(String dbName, String graphName, long createMillis) {
            this.dbName = dbName;
            this.graphName = graphName;
            this.createMillis = createMillis;
        }
    }
}

