/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.cypher;

import java.util.stream.Stream;
import org.apache.commons.lang3.mutable.MutableLong;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.api.DatabaseNotFoundException;
import org.neo4j.gds.BaseProc;
import org.neo4j.gds.compat.GraphDatabaseApiProxy;
import org.neo4j.gds.core.utils.ProgressTimer;
import org.neo4j.gds.cypher.GraphCreateCypherDbProc;
import org.neo4j.gds.executor.ProcPreconditions;
import org.neo4j.gds.storageengine.InMemoryDatabaseCreationCatalog;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class DropCypherDbProc
extends BaseProc {
    private static final String DESCRIPTION = "Drop a database backed by an in-memory graph";

    @Procedure(name="gds.alpha.drop.cypherdb", mode=Mode.WRITE)
    @Description(value="Drop a database backed by an in-memory graph")
    public Stream<DropCypherDbResult> dropDb(@Name(value="dbName") String dbName) {
        ProcPreconditions.check();
        DropCypherDbResult result = (DropCypherDbResult)this.runWithExceptionLogging("Drop in-memory Cypher database failed", () -> {
            GraphCreateCypherDbProc.validateNeo4jEnterpriseEdition(this.databaseService);
            DatabaseManagementService dbms = (DatabaseManagementService)GraphDatabaseApiProxy.resolveDependency((GraphDatabaseService)this.databaseService, DatabaseManagementService.class);
            DropCypherDbProc.validateDatabaseName(dbName, dbms);
            MutableLong dropMillis = new MutableLong(0L);
            try (ProgressTimer ignored = ProgressTimer.start(arg_0 -> ((MutableLong)dropMillis).setValue(arg_0));){
                dbms.dropDatabase(dbName);
            }
            return new DropCypherDbResult(dbName, dropMillis.getValue());
        });
        return Stream.of(result);
    }

    private static void validateDatabaseName(String dbName, DatabaseManagementService dbms) {
        if (!dbms.listDatabases().contains(dbName)) {
            throw new DatabaseNotFoundException(StringFormatting.formatWithLocale((String)"A database with name `%s` does not exist", (Object[])new Object[]{dbName}));
        }
        String graphName = InMemoryDatabaseCreationCatalog.getRegisteredDbCreationGraphName((String)dbName);
        if (graphName == null) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Database with name `%s` is not an in-memory database", (Object[])new Object[]{dbName}));
        }
    }

    public static class DropCypherDbResult {
        public final String dbName;
        public final long dropMillis;

        public DropCypherDbResult(String dbName, long dropMillis) {
            this.dbName = dbName;
            this.dropMillis = dropMillis;
        }
    }
}

