/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.approxmaxkcut;

import org.neo4j.gds.CommunityProcCompanion;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.api.properties.nodes.LongNodePropertyValues;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.config.ConcurrencyConfig;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.impl.approxmaxkcut.ApproxMaxKCut;
import org.neo4j.gds.impl.approxmaxkcut.ApproxMaxKCutFactory;
import org.neo4j.gds.impl.approxmaxkcut.config.ApproxMaxKCutConfig;

public final class ApproxMaxKCutProc {
    static final String APPROX_MAX_K_CUT_DESCRIPTION = "Approximate Maximum k-cut maps each node into one of k disjoint communities trying to maximize the sum of weights of relationships between these communities.";

    private ApproxMaxKCutProc() {
    }

    static <CONFIG extends ApproxMaxKCutConfig> GraphAlgorithmFactory<ApproxMaxKCut, CONFIG> algorithmFactory() {
        return new ApproxMaxKCutFactory();
    }

    static <CONFIG extends ApproxMaxKCutConfig> NodePropertyValues nodeProperties(ComputationResult<ApproxMaxKCut, ApproxMaxKCut.CutResult, CONFIG> computationResult) {
        ApproxMaxKCutConfig config = (ApproxMaxKCutConfig)computationResult.config();
        return CommunityProcCompanion.considerSizeFilter((ConcurrencyConfig)config, (LongNodePropertyValues)((ApproxMaxKCut.CutResult)computationResult.result()).asNodeProperties());
    }
}

