/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.centrality;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.api.properties.nodes.DoubleNodePropertyValues;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.centrality.CentralityScore;
import org.neo4j.gds.centrality.HarmonicCentralityProc;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.core.concurrency.Pools;
import org.neo4j.gds.core.utils.ProgressTimer;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.utils.progress.tasks.TaskProgressTracker;
import org.neo4j.gds.core.write.NodePropertyExporter;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ComputationResultConsumer;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.impl.closeness.HarmonicCentralityConfig;
import org.neo4j.gds.impl.harmonic.HarmonicCentrality;
import org.neo4j.gds.result.AbstractCentralityResultBuilder;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@GdsCallable(name="gds.alpha.closeness.harmonic.write", description="Harmonic centrality is a way of detecting nodes that are able to spread information very efficiently through a graph.", executionMode=ExecutionMode.WRITE_NODE_PROPERTY)
public class HarmonicCentralityWriteProc
extends HarmonicCentralityProc<CentralityScore.Stats> {
    @Procedure(value="gds.alpha.closeness.harmonic.write", mode=Mode.WRITE)
    @Description(value="Harmonic centrality is a way of detecting nodes that are able to spread information very efficiently through a graph.")
    public Stream<CentralityScore.Stats> write(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        ComputationResult computationResult = this.compute(graphName, configuration);
        return (Stream)this.computationResultConsumer().consume(computationResult, this.executionContext());
    }

    public ComputationResultConsumer<HarmonicCentrality, HarmonicCentrality, HarmonicCentralityConfig, Stream<CentralityScore.Stats>> computationResultConsumer() {
        return (computationResult, executionContext) -> {
            HarmonicCentrality algorithm = (HarmonicCentrality)computationResult.algorithm();
            HarmonicCentralityConfig config = (HarmonicCentralityConfig)computationResult.config();
            Graph graph = computationResult.graph();
            CentralityScore.Stats.Builder builder = new CentralityScore.Stats.Builder(this.callContext, config.concurrency());
            builder.withNodeCount(graph.nodeCount()).withConfig((AlgoBaseConfig)config).withComputeMillis(computationResult.computeMillis()).withPreProcessingMillis(computationResult.preProcessingMillis());
            if (graph.isEmpty()) {
                graph.release();
                return Stream.of((CentralityScore.Stats)builder.build());
            }
            builder.withCentralityFunction(arg_0 -> ((HarmonicCentrality)((HarmonicCentrality)computationResult.result())).getCentralityScore(arg_0));
            try (ProgressTimer ignore = ProgressTimer.start(arg_0 -> ((AbstractCentralityResultBuilder)builder).withWriteMillis(arg_0));){
                int writeConcurrency = ((HarmonicCentralityConfig)computationResult.config()).writeConcurrency();
                TaskProgressTracker progressTracker = new TaskProgressTracker(NodePropertyExporter.baseTask((String)"HarmonicCentrality", (long)graph.nodeCount()), this.log, writeConcurrency, this.taskRegistryFactory);
                NodePropertyExporter exporter = this.nodePropertyExporterBuilder.withIdMap((IdMap)graph).withTerminationFlag(algorithm.getTerminationFlag()).withProgressTracker((ProgressTracker)progressTracker).parallel(Pools.DEFAULT, writeConcurrency).build();
                DoubleNodePropertyValues properties = new DoubleNodePropertyValues(){

                    public long nodeCount() {
                        return computationResult.graph().nodeCount();
                    }

                    public double doubleValue(long nodeId) {
                        return ((HarmonicCentrality)computationResult.result()).getCentralityScore(nodeId);
                    }
                };
                exporter.write(config.writeProperty(), (NodePropertyValues)properties);
            }
            return Stream.of((CentralityScore.Stats)builder.build());
        };
    }
}

