/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.influenceMaximization;

import com.carrotsearch.hppc.LongDoubleScatterMap;
import java.util.Arrays;
import java.util.stream.Stream;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.concurrency.Pools;
import org.neo4j.gds.core.utils.ProgressTimer;
import org.neo4j.gds.core.write.NodePropertyExporter;
import org.neo4j.gds.executor.AlgorithmSpec;
import org.neo4j.gds.executor.AlgorithmSpecProgressTrackerProvider;
import org.neo4j.gds.executor.ComputationResultConsumer;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.executor.NewConfigFunction;
import org.neo4j.gds.influenceMaximization.CELF;
import org.neo4j.gds.influenceMaximization.CELFAlgorithmFactory;
import org.neo4j.gds.influenceMaximization.CelfNodeProperties;
import org.neo4j.gds.influenceMaximization.InfluenceMaximizationWriteConfig;
import org.neo4j.gds.influenceMaximization.WriteResult;
import org.neo4j.gds.result.AbstractResultBuilder;

@GdsCallable(name="gds.beta.influenceMaximization.celf.write", description="The Cost Effective Lazy Forward (CELF) algorithm aims to find k nodes that maximize the expected spread of influence in the network.", executionMode=ExecutionMode.WRITE_NODE_PROPERTY)
public class CELFWriteSpec
implements AlgorithmSpec<CELF, LongDoubleScatterMap, InfluenceMaximizationWriteConfig, Stream<WriteResult>, CELFAlgorithmFactory<InfluenceMaximizationWriteConfig>> {
    public String name() {
        return "CELFStream";
    }

    public CELFAlgorithmFactory<InfluenceMaximizationWriteConfig> algorithmFactory() {
        return new CELFAlgorithmFactory();
    }

    public NewConfigFunction<InfluenceMaximizationWriteConfig> newConfigFunction() {
        return (__, userInput) -> InfluenceMaximizationWriteConfig.of((CypherMapWrapper)userInput);
    }

    public ComputationResultConsumer<CELF, LongDoubleScatterMap, InfluenceMaximizationWriteConfig, Stream<WriteResult>> computationResultConsumer() {
        return (computationResult, executionContext) -> {
            LongDoubleScatterMap celfSeedSet = (LongDoubleScatterMap)computationResult.result();
            Graph graph = computationResult.graph();
            InfluenceMaximizationWriteConfig config = (InfluenceMaximizationWriteConfig)computationResult.config();
            AbstractResultBuilder builder = WriteResult.builder().withTotalSpread(Arrays.stream(celfSeedSet.values).sum()).withNodeCount(graph.nodeCount()).withComputeMillis(computationResult.computeMillis()).withConfig((AlgoBaseConfig)config);
            try (ProgressTimer ignore = ProgressTimer.start(arg_0 -> ((AbstractResultBuilder)builder).withWriteMillis(arg_0));){
                int writeConcurrency = ((InfluenceMaximizationWriteConfig)computationResult.config()).writeConcurrency();
                CELF algorithm = (CELF)computationResult.algorithm();
                NodePropertyExporter exporter = executionContext.nodePropertyExporterBuilder().withIdMap((IdMap)graph).withTerminationFlag(algorithm.getTerminationFlag()).withProgressTracker(AlgorithmSpecProgressTrackerProvider.createProgressTracker((String)this.name(), (long)graph.nodeCount(), (int)writeConcurrency, (ExecutionContext)executionContext)).parallel(Pools.DEFAULT, writeConcurrency).build();
                CelfNodeProperties properties = new CelfNodeProperties(celfSeedSet, graph.nodeCount());
                exporter.write(config.writeProperty(), (NodePropertyValues)properties);
                builder.withNodePropertiesWritten(exporter.propertiesWritten());
            }
            return Stream.of((WriteResult)builder.build());
        };
    }
}

