/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.spanningtree;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.BaseProc;
import org.neo4j.gds.core.write.NodePropertyExporter;
import org.neo4j.gds.core.write.NodePropertyExporterBuilder;
import org.neo4j.gds.executor.AlgorithmSpec;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.executor.ImmutableExecutionContext;
import org.neo4j.gds.executor.ProcedureExecutor;
import org.neo4j.gds.spanningtree.KSpanningTreeWriteResult;
import org.neo4j.gds.spanningtree.KSpanningTreeWriteSpec;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class KSpanningWriteTreeProc
extends BaseProc {
    static final String DESCRIPTION = "The K-spanning tree algorithm starts from a root node and returns a spanning tree with exactly k nodes";
    @Context
    public NodePropertyExporterBuilder<? extends NodePropertyExporter> nodePropertyExporterBuilder;

    @Procedure(value="gds.alpha.kSpanningTree.write", mode=Mode.WRITE)
    @Description(value="The K-spanning tree algorithm starts from a root node and returns a spanning tree with exactly k nodes")
    public Stream<KSpanningTreeWriteResult> write(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return (Stream)new ProcedureExecutor((AlgorithmSpec)new KSpanningTreeWriteSpec(), this.executionContext()).compute(graphName, configuration, true, true);
    }

    public ExecutionContext executionContext() {
        return ImmutableExecutionContext.builder().databaseService(this.databaseService).log(this.log).procedureTransaction(this.procedureTransaction).transaction(this.transaction).callContext(this.callContext).userLogRegistryFactory(this.userLogRegistryFactory).taskRegistryFactory(this.taskRegistryFactory).username(this.username()).nodePropertyExporterBuilder(this.nodePropertyExporterBuilder).build();
    }
}

