/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.modularity;

import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.executor.AlgorithmSpec;
import org.neo4j.gds.executor.ComputationResultConsumer;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.executor.NewConfigFunction;
import org.neo4j.gds.modularity.ModularityCalculator;
import org.neo4j.gds.modularity.ModularityCalculatorFactory;
import org.neo4j.gds.modularity.ModularityResult;
import org.neo4j.gds.modularity.ModularityStatsConfig;
import org.neo4j.gds.modularity.StatsResult;

@GdsCallable(name="gds.alpha.modularity.stats", description="TODO: Add modularity description", executionMode=ExecutionMode.STATS)
public class ModularityStatsSpec
implements AlgorithmSpec<ModularityCalculator, ModularityResult, ModularityStatsConfig, Stream<StatsResult>, ModularityCalculatorFactory<ModularityStatsConfig>> {
    public String name() {
        return "ModularityStats";
    }

    public ModularityCalculatorFactory<ModularityStatsConfig> algorithmFactory() {
        return new ModularityCalculatorFactory();
    }

    public NewConfigFunction<ModularityStatsConfig> newConfigFunction() {
        return (__, userInput) -> ModularityStatsConfig.of((CypherMapWrapper)userInput);
    }

    public ComputationResultConsumer<ModularityCalculator, ModularityResult, ModularityStatsConfig, Stream<StatsResult>> computationResultConsumer() {
        return (computationResult, executionContext) -> {
            ModularityStatsConfig config = (ModularityStatsConfig)computationResult.config();
            StatsResult.StatsBuilder statsBuilder = new StatsResult.StatsBuilder(executionContext.callContext(), config.concurrency());
            ModularityResult result = Optional.ofNullable((ModularityResult)computationResult.result()).orElseGet(ModularityResult::empty);
            StatsResult statsResult = (StatsResult)((Object)((Object)statsBuilder.withModularity(result.totalModularity()).withCommunityCount(result.communityCount()).withRelationshipCount(computationResult.graph().relationshipCount()).withPreProcessingMillis(computationResult.preProcessingMillis()).withComputeMillis(computationResult.computeMillis()).withNodeCount(computationResult.graph().nodeCount()).withConfig(computationResult.config()).build()));
            return Stream.of(statsResult);
        };
    }
}

