/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.scaling;

import org.neo4j.gds.api.properties.nodes.DoubleArrayNodePropertyValues;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.core.utils.paged.HugeObjectArray;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.scaling.ScaleProperties;
import org.neo4j.gds.scaling.ScalePropertiesBaseConfig;

public final class ScalePropertiesProc {
    private ScalePropertiesProc() {
    }

    static NodePropertyValues nodeProperties(ComputationResult<ScaleProperties, ScaleProperties.Result, ? extends ScalePropertiesBaseConfig> computationResult) {
        final long size = computationResult.graph().nodeCount();
        final HugeObjectArray scaledProperties = ((ScaleProperties.Result)computationResult.result()).scaledProperties();
        return new DoubleArrayNodePropertyValues(){

            public long nodeCount() {
                return size;
            }

            public double[] doubleArrayValue(long nodeId) {
                return (double[])scaledProperties.get(nodeId);
            }
        };
    }
}

