/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.modularity;

import java.util.Optional;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.utils.paged.HugeObjectArray;
import org.neo4j.gds.executor.AlgorithmSpec;
import org.neo4j.gds.executor.ComputationResultConsumer;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.executor.NewConfigFunction;
import org.neo4j.gds.modularity.ModularityCalculator;
import org.neo4j.gds.modularity.ModularityCalculatorFactory;
import org.neo4j.gds.modularity.ModularityResult;
import org.neo4j.gds.modularity.ModularityStreamConfig;
import org.neo4j.gds.modularity.StreamResult;

@GdsCallable(name="gds.alpha.modularity.stream", description="TODO: Add modularity description", executionMode=ExecutionMode.STREAM)
public class ModularityStreamSpec
implements AlgorithmSpec<ModularityCalculator, ModularityResult, ModularityStreamConfig, Stream<StreamResult>, ModularityCalculatorFactory<ModularityStreamConfig>> {
    public String name() {
        return "ModularityStream";
    }

    public ModularityCalculatorFactory<ModularityStreamConfig> algorithmFactory() {
        return new ModularityCalculatorFactory();
    }

    public NewConfigFunction<ModularityStreamConfig> newConfigFunction() {
        return (__, userInput) -> ModularityStreamConfig.of((CypherMapWrapper)userInput);
    }

    public ComputationResultConsumer<ModularityCalculator, ModularityResult, ModularityStreamConfig, Stream<StreamResult>> computationResultConsumer() {
        return (computationResult, executionContext) -> {
            ModularityResult modularityResult = Optional.ofNullable((ModularityResult)computationResult.result()).orElseGet(ModularityResult::empty);
            HugeObjectArray communityModularities = modularityResult.modularityScores();
            return LongStream.range(0L, modularityResult.communityCount()).mapToObj(arg_0 -> ((HugeObjectArray)communityModularities).get(arg_0)).map(StreamResult::from);
        };
    }
}

