/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.influenceMaximization;

import com.carrotsearch.hppc.LongDoubleScatterMap;
import java.util.Arrays;
import java.util.stream.Stream;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.executor.AlgorithmSpec;
import org.neo4j.gds.executor.ComputationResultConsumer;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.executor.NewConfigFunction;
import org.neo4j.gds.influenceMaximization.CELF;
import org.neo4j.gds.influenceMaximization.CELFAlgorithmFactory;
import org.neo4j.gds.influenceMaximization.InfluenceMaximizationStatsConfig;
import org.neo4j.gds.influenceMaximization.StatsResult;

@GdsCallable(name="gds.beta.influenceMaximization.celf.stats", description="The Cost Effective Lazy Forward (CELF) algorithm aims to find k nodes that maximize the expected spread of influence in the network.", executionMode=ExecutionMode.STATS)
public class CELFStatsSpec
implements AlgorithmSpec<CELF, LongDoubleScatterMap, InfluenceMaximizationStatsConfig, Stream<StatsResult>, CELFAlgorithmFactory<InfluenceMaximizationStatsConfig>> {
    public String name() {
        return "CELFStats";
    }

    public CELFAlgorithmFactory<InfluenceMaximizationStatsConfig> algorithmFactory() {
        return new CELFAlgorithmFactory();
    }

    public NewConfigFunction<InfluenceMaximizationStatsConfig> newConfigFunction() {
        return (__, userInput) -> InfluenceMaximizationStatsConfig.of((CypherMapWrapper)userInput);
    }

    public ComputationResultConsumer<CELF, LongDoubleScatterMap, InfluenceMaximizationStatsConfig, Stream<StatsResult>> computationResultConsumer() {
        return (computationResult, executionContext) -> {
            LongDoubleScatterMap celfSpreadSet = (LongDoubleScatterMap)computationResult.result();
            if (celfSpreadSet == null) {
                return Stream.empty();
            }
            StatsResult.Builder statsBuilder = StatsResult.builder();
            StatsResult statsResult = (StatsResult)statsBuilder.withTotalSpread(Arrays.stream(celfSpreadSet.values).sum()).withNodeCount(computationResult.graph().nodeCount()).withComputeMillis(computationResult.computeMillis()).withConfig(computationResult.config()).build();
            return Stream.of(statsResult);
        };
    }
}

