/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.spanningtree;

import java.util.stream.Stream;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.api.properties.nodes.LongNodePropertyValues;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.utils.ProgressTimer;
import org.neo4j.gds.executor.AlgorithmSpec;
import org.neo4j.gds.executor.AlgorithmSpecProgressTrackerProvider;
import org.neo4j.gds.executor.ComputationResultConsumer;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.executor.NewConfigFunction;
import org.neo4j.gds.impl.spanningtree.KSpanningTree;
import org.neo4j.gds.impl.spanningtree.KSpanningTreeAlgorithmFactory;
import org.neo4j.gds.impl.spanningtree.KSpanningTreeWriteConfig;
import org.neo4j.gds.spanningtree.KSpanningTreeWriteResult;
import org.neo4j.gds.spanningtree.SpanningTree;

@GdsCallable(name="gds.alpha.kSpanningTree.write", description="The K-spanning tree algorithm starts from a root node and returns a spanning tree with exactly k nodes", executionMode=ExecutionMode.WRITE_RELATIONSHIP)
public class KSpanningTreeWriteSpec
implements AlgorithmSpec<KSpanningTree, SpanningTree, KSpanningTreeWriteConfig, Stream<KSpanningTreeWriteResult>, KSpanningTreeAlgorithmFactory<KSpanningTreeWriteConfig>> {
    public String name() {
        return "KSpanningTreeWrite";
    }

    public KSpanningTreeAlgorithmFactory<KSpanningTreeWriteConfig> algorithmFactory() {
        return new KSpanningTreeAlgorithmFactory();
    }

    public NewConfigFunction<KSpanningTreeWriteConfig> newConfigFunction() {
        return (__, config) -> KSpanningTreeWriteConfig.of((CypherMapWrapper)config);
    }

    public ComputationResultConsumer<KSpanningTree, SpanningTree, KSpanningTreeWriteConfig, Stream<KSpanningTreeWriteResult>> computationResultConsumer() {
        return (computationResult, executionContext) -> {
            Graph graph = computationResult.graph();
            final SpanningTree spanningTree = (SpanningTree)computationResult.result();
            KSpanningTreeWriteConfig config = (KSpanningTreeWriteConfig)computationResult.config();
            KSpanningTree algorithm = (KSpanningTree)computationResult.algorithm();
            KSpanningTreeWriteResult.Builder builder = new KSpanningTreeWriteResult.Builder();
            if (graph.isEmpty()) {
                graph.release();
                return Stream.of(builder.build());
            }
            LongNodePropertyValues properties = new LongNodePropertyValues(){

                public long size() {
                    return computationResult.graph().nodeCount();
                }

                public long longValue(long nodeId) {
                    return spanningTree.head(nodeId);
                }
            };
            builder.withEffectiveNodeCount(spanningTree.effectiveNodeCount());
            try (ProgressTimer ignored = ProgressTimer.start(arg_0 -> ((KSpanningTreeWriteResult.Builder)builder).withWriteMillis(arg_0));){
                executionContext.nodePropertyExporterBuilder().withIdMap((IdMap)graph).withTerminationFlag(algorithm.getTerminationFlag()).withProgressTracker(AlgorithmSpecProgressTrackerProvider.createProgressTracker((String)this.name(), (long)graph.nodeCount(), (int)config.writeConcurrency(), (ExecutionContext)executionContext)).build().write(config.writeProperty(), (NodePropertyValues)properties);
            }
            builder.withComputeMillis(computationResult.computeMillis());
            builder.withPreProcessingMillis(computationResult.preProcessingMillis());
            builder.withConfig((AlgoBaseConfig)config);
            return Stream.of(builder.build());
        };
    }
}

