/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.influenceMaximization;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.BaseProc;
import org.neo4j.gds.core.write.NodePropertyExporter;
import org.neo4j.gds.core.write.NodePropertyExporterBuilder;
import org.neo4j.gds.executor.AlgorithmSpec;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.executor.ImmutableExecutionContext;
import org.neo4j.gds.executor.MemoryEstimationExecutor;
import org.neo4j.gds.executor.ProcedureExecutor;
import org.neo4j.gds.influenceMaximization.CELFWriteSpec;
import org.neo4j.gds.influenceMaximization.WriteResult;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class CELFWriteProc
extends BaseProc {
    @Context
    public NodePropertyExporterBuilder<? extends NodePropertyExporter> nodePropertyExporterBuilder;

    @Procedure(value="gds.beta.influenceMaximization.celf.write", mode=Mode.WRITE)
    @Description(value="The Cost Effective Lazy Forward (CELF) algorithm aims to find k nodes that maximize the expected spread of influence in the network.")
    public Stream<WriteResult> write(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return (Stream)new ProcedureExecutor((AlgorithmSpec)new CELFWriteSpec(), this.executionContext()).compute(graphName, configuration, true, true);
    }

    @Procedure(name="gds.beta.influenceMaximization.celf.write.estimate", mode=Mode.READ)
    @Description(value="Returns an estimation of the memory consumption for that procedure.")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphNameOrConfiguration") Object graphNameOrConfiguration, @Name(value="algoConfiguration") Map<String, Object> algoConfiguration) {
        CELFWriteSpec writeSpec = new CELFWriteSpec();
        return new MemoryEstimationExecutor((AlgorithmSpec)writeSpec, this.executionContext()).computeEstimate(graphNameOrConfiguration, algoConfiguration);
    }

    public ExecutionContext executionContext() {
        return ImmutableExecutionContext.builder().databaseService(this.databaseService).modelCatalog(this.internalModelCatalog).log(this.log).procedureTransaction(this.procedureTransaction).transaction(this.transaction).callContext(this.callContext).userLogRegistryFactory(this.userLogRegistryFactory).taskRegistryFactory(this.taskRegistryFactory).username(this.username()).nodePropertyExporterBuilder(this.nodePropertyExporterBuilder).build();
    }
}

