/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.modularity;

import java.util.Map;
import org.neo4j.gds.result.AbstractCommunityResultBuilder;
import org.neo4j.gds.results.StandardStatsResult;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;

public class StatsResult
extends StandardStatsResult {
    public final long nodeCount;
    public final long relationshipCount;
    public final long communityCount;
    public final double modularity;

    StatsResult(long nodeCount, long relationshipCount, long communityCount, double modularity, long preProcessingMillis, long computeMillis, long postProcessingMillis, Map<String, Object> configuration) {
        super(preProcessingMillis, computeMillis, postProcessingMillis, configuration);
        this.nodeCount = nodeCount;
        this.relationshipCount = relationshipCount;
        this.communityCount = communityCount;
        this.modularity = modularity;
    }

    static class StatsBuilder
    extends AbstractCommunityResultBuilder<StatsResult> {
        double modularity;
        private long relationshipCount;
        private long communityCount;

        StatsBuilder(ProcedureCallContext context, int concurrency) {
            super(context, concurrency);
        }

        StatsBuilder withModularity(double modularity) {
            this.modularity = modularity;
            return this;
        }

        StatsBuilder withRelationshipCount(long relationshipCount) {
            this.relationshipCount = relationshipCount;
            return this;
        }

        StatsBuilder withCommunityCount(long communityCount) {
            this.communityCount = communityCount;
            return this;
        }

        protected StatsResult buildResult() {
            return new StatsResult(this.nodeCount, this.relationshipCount, this.communityCount, this.modularity, this.preProcessingMillis, this.computeMillis, this.postProcessingDuration, this.config.toMap());
        }
    }
}

