/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.spanningtree;

import java.util.Map;
import java.util.function.DoubleUnaryOperator;
import java.util.stream.Stream;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.impl.spanningtree.KSpanningTreeConfig;
import org.neo4j.gds.spanningtree.KSpanningTreeProc;
import org.neo4j.gds.spanningtree.KSpanningTreeWriteResult;
import org.neo4j.gds.spanningtree.Prim;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@GdsCallable(name="gds.alpha.spanningTree.kmax.write", description="The maximum weight spanning tree (MST) starts from a given node, and finds all its reachable nodes and the set of relationships that connect the nodes together with the maximum possible weight.", executionMode=ExecutionMode.WRITE_NODE_PROPERTY)
public class KSpanningTreeMaxProc
extends KSpanningTreeProc {
    public static final String DESCRIPTION = "The maximum weight spanning tree (MST) starts from a given node, and finds all its reachable nodes and the set of relationships that connect the nodes together with the maximum possible weight.";

    @Procedure(value="gds.alpha.spanningTree.kmax.write", mode=Mode.WRITE)
    @Description(value="The maximum weight spanning tree (MST) starts from a given node, and finds all its reachable nodes and the set of relationships that connect the nodes together with the maximum possible weight.")
    public Stream<KSpanningTreeWriteResult> kmax(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        ComputationResult computationResult = this.compute(graphName, configuration);
        return (Stream)this.computationResultConsumer().consume(computationResult, this.executionContext());
    }

    protected KSpanningTreeConfig newConfig(String username, CypherMapWrapper config) {
        return KSpanningTreeConfig.of((DoubleUnaryOperator)Prim.MAX_OPERATOR, (CypherMapWrapper)config);
    }
}

