/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.spanningtree;

import java.util.stream.Stream;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.utils.ProgressTimer;
import org.neo4j.gds.executor.AlgorithmSpec;
import org.neo4j.gds.executor.AlgorithmSpecProgressTrackerProvider;
import org.neo4j.gds.executor.ComputationResultConsumer;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.executor.NewConfigFunction;
import org.neo4j.gds.impl.spanningtree.Prim;
import org.neo4j.gds.impl.spanningtree.SpanningGraph;
import org.neo4j.gds.impl.spanningtree.SpanningTree;
import org.neo4j.gds.impl.spanningtree.SpanningTreeAlgorithmFactory;
import org.neo4j.gds.impl.spanningtree.SpanningTreeWriteConfig;
import org.neo4j.gds.spanningtree.WriteResult;

@GdsCallable(name="gds.alpha.spanningTree.write", description="The spanning tree algorithm visits all nodes that are in the same connected component as the starting node, and returns a spanning tree of all nodes in the component where the total weight of the relationships is either minimized or maximized.", executionMode=ExecutionMode.MUTATE_RELATIONSHIP)
public class SpanningTreeWriteSpec
implements AlgorithmSpec<Prim, SpanningTree, SpanningTreeWriteConfig, Stream<WriteResult>, SpanningTreeAlgorithmFactory<SpanningTreeWriteConfig>> {
    public String name() {
        return "SpanningTreeWrite";
    }

    public SpanningTreeAlgorithmFactory<SpanningTreeWriteConfig> algorithmFactory() {
        return new SpanningTreeAlgorithmFactory();
    }

    public NewConfigFunction<SpanningTreeWriteConfig> newConfigFunction() {
        return (__, config) -> SpanningTreeWriteConfig.of((CypherMapWrapper)config);
    }

    public ComputationResultConsumer<Prim, SpanningTree, SpanningTreeWriteConfig, Stream<WriteResult>> computationResultConsumer() {
        return (computationResult, executionContext) -> {
            Graph graph = computationResult.graph();
            Prim prim = (Prim)computationResult.algorithm();
            SpanningTree spanningTree = (SpanningTree)computationResult.result();
            SpanningTreeWriteConfig config = (SpanningTreeWriteConfig)computationResult.config();
            WriteResult.Builder builder = new WriteResult.Builder();
            if (graph.isEmpty()) {
                graph.release();
                return Stream.of(builder.build());
            }
            builder.withEffectiveNodeCount(spanningTree.effectiveNodeCount());
            builder.withTotalWeight(spanningTree.totalWeight());
            try (ProgressTimer ignored = ProgressTimer.start(arg_0 -> ((WriteResult.Builder)builder).withWriteMillis(arg_0));){
                SpanningGraph spanningGraph = new SpanningGraph(graph, spanningTree);
                executionContext.relationshipExporterBuilder().withGraph((Graph)spanningGraph).withIdMappingOperator(arg_0 -> ((SpanningGraph)spanningGraph).toOriginalNodeId(arg_0)).withTerminationFlag(prim.getTerminationFlag()).withProgressTracker(AlgorithmSpecProgressTrackerProvider.createProgressTracker((String)this.name(), (long)graph.nodeCount(), (int)config.writeConcurrency(), (ExecutionContext)executionContext)).build().write(config.writeProperty(), config.weightWriteProperty());
            }
            builder.withComputeMillis(computationResult.computeMillis());
            builder.withPreProcessingMillis(computationResult.preProcessingMillis());
            builder.withRelationshipsWritten(spanningTree.effectiveNodeCount() - 1L);
            builder.withConfig((AlgoBaseConfig)config);
            return Stream.of(builder.build());
        };
    }
}

