/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.spanningtree;

import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.executor.AlgorithmSpec;
import org.neo4j.gds.executor.ComputationResultConsumer;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.executor.NewConfigFunction;
import org.neo4j.gds.impl.spanningtree.Prim;
import org.neo4j.gds.impl.spanningtree.SpanningTree;
import org.neo4j.gds.impl.spanningtree.SpanningTreeAlgorithmFactory;
import org.neo4j.gds.impl.spanningtree.SpanningTreeStreamConfig;
import org.neo4j.gds.spanningtree.StreamResult;

@GdsCallable(name="gds.alpha.spanningTree.stream", description="The spanning tree algorithm visits all nodes that are in the same connected component as the starting node, and returns a spanning tree of all nodes in the component where the total weight of the relationships is either minimized or maximized.", executionMode=ExecutionMode.STREAM)
public class SpanningTreeStreamSpec
implements AlgorithmSpec<Prim, SpanningTree, SpanningTreeStreamConfig, Stream<StreamResult>, SpanningTreeAlgorithmFactory<SpanningTreeStreamConfig>> {
    public String name() {
        return "SpanningTreeStream";
    }

    public SpanningTreeAlgorithmFactory<SpanningTreeStreamConfig> algorithmFactory() {
        return new SpanningTreeAlgorithmFactory();
    }

    public NewConfigFunction<SpanningTreeStreamConfig> newConfigFunction() {
        return (__, config) -> SpanningTreeStreamConfig.of((CypherMapWrapper)config);
    }

    public ComputationResultConsumer<Prim, SpanningTree, SpanningTreeStreamConfig, Stream<StreamResult>> computationResultConsumer() {
        return (computationResult, executionContext) -> {
            long sourceNode = ((SpanningTreeStreamConfig)computationResult.config()).sourceNode();
            Graph graph = computationResult.graph();
            SpanningTree spanningTree = (SpanningTree)computationResult.result();
            return LongStream.range(0L, graph.nodeCount()).filter(nodeId -> spanningTree.parent(nodeId) >= 0L || sourceNode == graph.toOriginalNodeId(nodeId)).mapToObj(nodeId -> new StreamResult(graph.toOriginalNodeId(nodeId), sourceNode == graph.toOriginalNodeId(nodeId) ? sourceNode : graph.toOriginalNodeId(spanningTree.parent(nodeId)), spanningTree.costToParent(nodeId)));
        };
    }
}

