/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.spanningtree;

import java.util.stream.Stream;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.executor.AlgorithmSpec;
import org.neo4j.gds.executor.ComputationResultConsumer;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.executor.NewConfigFunction;
import org.neo4j.gds.impl.spanningtree.Prim;
import org.neo4j.gds.impl.spanningtree.SpanningTree;
import org.neo4j.gds.impl.spanningtree.SpanningTreeAlgorithmFactory;
import org.neo4j.gds.impl.spanningtree.SpanningTreeStatsConfig;
import org.neo4j.gds.spanningtree.StatsResult;

@GdsCallable(name="gds.alpha.spanningTree.stats", description="The spanning tree algorithm visits all nodes that are in the same connected component as the starting node, and returns a spanning tree of all nodes in the component where the total weight of the relationships is either minimized or maximized.", executionMode=ExecutionMode.STATS)
public class SpanningTreeStatsSpec
implements AlgorithmSpec<Prim, SpanningTree, SpanningTreeStatsConfig, Stream<StatsResult>, SpanningTreeAlgorithmFactory<SpanningTreeStatsConfig>> {
    public String name() {
        return "SpanningTreeStats";
    }

    public SpanningTreeAlgorithmFactory<SpanningTreeStatsConfig> algorithmFactory() {
        return new SpanningTreeAlgorithmFactory();
    }

    public NewConfigFunction<SpanningTreeStatsConfig> newConfigFunction() {
        return (__, config) -> SpanningTreeStatsConfig.of((CypherMapWrapper)config);
    }

    public ComputationResultConsumer<Prim, SpanningTree, SpanningTreeStatsConfig, Stream<StatsResult>> computationResultConsumer() {
        return (computationResult, executionContext) -> {
            Graph graph = computationResult.graph();
            Prim prim = (Prim)computationResult.algorithm();
            SpanningTree spanningTree = (SpanningTree)computationResult.result();
            SpanningTreeStatsConfig config = (SpanningTreeStatsConfig)computationResult.config();
            StatsResult.Builder builder = new StatsResult.Builder();
            if (graph.isEmpty()) {
                graph.release();
                return Stream.of(builder.build());
            }
            builder.withEffectiveNodeCount(spanningTree.effectiveNodeCount());
            builder.withtotalWeight(spanningTree.totalWeight());
            builder.withComputeMillis(computationResult.computeMillis());
            builder.withPreProcessingMillis(computationResult.preProcessingMillis());
            builder.withConfig((AlgoBaseConfig)config);
            return Stream.of(builder.build());
        };
    }
}

