/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.spanningtree;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.BaseProc;
import org.neo4j.gds.core.write.RelationshipExporter;
import org.neo4j.gds.core.write.RelationshipExporterBuilder;
import org.neo4j.gds.executor.AlgorithmSpec;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.executor.ImmutableExecutionContext;
import org.neo4j.gds.executor.MemoryEstimationExecutor;
import org.neo4j.gds.executor.ProcedureExecutor;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.gds.spanningtree.SpanningTreeStatsSpec;
import org.neo4j.gds.spanningtree.StatsResult;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class SpanningTreeStatsProc
extends BaseProc {
    static final String procedure = "gds.alpha.spanningTree.stats";
    static final String DESCRIPTION = "The spanning tree algorithm visits all nodes that are in the same connected component as the starting node, and returns a spanning tree of all nodes in the component where the total weight of the relationships is either minimized or maximized.";
    @Context
    public RelationshipExporterBuilder<? extends RelationshipExporter> relationshipExporterBuilder;

    @Procedure(value="gds.alpha.spanningTree.stats", mode=Mode.READ)
    @Description(value="The spanning tree algorithm visits all nodes that are in the same connected component as the starting node, and returns a spanning tree of all nodes in the component where the total weight of the relationships is either minimized or maximized.")
    public Stream<StatsResult> spanningTree(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return (Stream)new ProcedureExecutor((AlgorithmSpec)new SpanningTreeStatsSpec(), this.executionContext()).compute(graphName, configuration, true, true);
    }

    @Procedure(value="gds.alpha.spanningTree.stats.estimate", mode=Mode.READ)
    @Description(value="Returns an estimation of the memory consumption for that procedure.")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphNameOrConfiguration") Object graphName, @Name(value="algoConfiguration") Map<String, Object> configuration) {
        SpanningTreeStatsSpec spec = new SpanningTreeStatsSpec();
        return new MemoryEstimationExecutor((AlgorithmSpec)spec, this.executionContext()).computeEstimate(graphName, configuration);
    }

    public ExecutionContext executionContext() {
        return ImmutableExecutionContext.builder().databaseService(this.databaseService).log(this.log).procedureTransaction(this.procedureTransaction).transaction(this.transaction).callContext(this.callContext).userLogRegistryFactory(this.userLogRegistryFactory).taskRegistryFactory(this.taskRegistryFactory).username(this.username()).relationshipExporterBuilder(this.relationshipExporterBuilder).build();
    }
}

