/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.spanningtree;

import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.gds.Orientation;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.DefaultValue;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.PartialIdMap;
import org.neo4j.gds.api.Relationships;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.core.Aggregation;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.loading.construction.GraphFactory;
import org.neo4j.gds.core.loading.construction.RelationshipsBuilder;
import org.neo4j.gds.core.utils.ProgressTimer;
import org.neo4j.gds.executor.AlgorithmSpec;
import org.neo4j.gds.executor.ComputationResultConsumer;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.executor.NewConfigFunction;
import org.neo4j.gds.impl.spanningtree.Prim;
import org.neo4j.gds.impl.spanningtree.SpanningGraph;
import org.neo4j.gds.impl.spanningtree.SpanningTree;
import org.neo4j.gds.impl.spanningtree.SpanningTreeAlgorithmFactory;
import org.neo4j.gds.impl.spanningtree.SpanningTreeMutateConfig;
import org.neo4j.gds.spanningtree.MutateResult;
import org.neo4j.values.storable.NumberType;

@GdsCallable(name="gds.alpha.spanningTree.mutate", description="The spanning tree algorithm visits all nodes that are in the same connected component as the starting node, and returns a spanning tree of all nodes in the component where the total weight of the relationships is either minimized or maximized.", executionMode=ExecutionMode.MUTATE_RELATIONSHIP)
public class SpanningTreeMutateSpec
implements AlgorithmSpec<Prim, SpanningTree, SpanningTreeMutateConfig, Stream<MutateResult>, SpanningTreeAlgorithmFactory<SpanningTreeMutateConfig>> {
    public String name() {
        return "SpanningTreeMutate";
    }

    public SpanningTreeAlgorithmFactory<SpanningTreeMutateConfig> algorithmFactory() {
        return new SpanningTreeAlgorithmFactory();
    }

    public NewConfigFunction<SpanningTreeMutateConfig> newConfigFunction() {
        return (__, config) -> SpanningTreeMutateConfig.of((CypherMapWrapper)config);
    }

    public ComputationResultConsumer<Prim, SpanningTree, SpanningTreeMutateConfig, Stream<MutateResult>> computationResultConsumer() {
        return (computationResult, executionContext) -> {
            Graph graph = computationResult.graph();
            Prim prim = (Prim)computationResult.algorithm();
            SpanningTree spanningTree = (SpanningTree)computationResult.result();
            SpanningTreeMutateConfig config = (SpanningTreeMutateConfig)computationResult.config();
            MutateResult.Builder builder = new MutateResult.Builder();
            if (graph.isEmpty()) {
                graph.release();
                return Stream.of(builder.build());
            }
            RelationshipsBuilder relationshipsBuilder = GraphFactory.initRelationshipsBuilder().nodes((PartialIdMap)computationResult.graph()).addPropertyConfig(Aggregation.NONE, DefaultValue.forDouble()).orientation(Orientation.NATURAL).build();
            RelationshipType mutateRelationshipType = RelationshipType.of((String)config.mutateProperty());
            builder.withEffectiveNodeCount(spanningTree.effectiveNodeCount());
            builder.withTotalWeight(spanningTree.totalWeight());
            try (ProgressTimer ignored = ProgressTimer.start(arg_0 -> ((MutateResult.Builder)builder).withMutateMillis(arg_0));){
                SpanningGraph spanningGraph = new SpanningGraph(graph, spanningTree);
                spanningGraph.forEachNode(nodeId -> {
                    spanningGraph.forEachRelationship(nodeId, 1.0, (s, t, w) -> {
                        relationshipsBuilder.addFromInternal(s, t, w);
                        return true;
                    });
                    return true;
                });
            }
            Relationships relationships = relationshipsBuilder.build();
            computationResult.graphStore().addRelationshipType(mutateRelationshipType, Optional.of(config.weightMutateProperty()), Optional.of(NumberType.FLOATING_POINT), relationships);
            builder.withComputeMillis(computationResult.computeMillis());
            builder.withPreProcessingMillis(computationResult.preProcessingMillis());
            builder.withRelationshipsWritten(spanningTree.effectiveNodeCount() - 1L);
            builder.withConfig((AlgoBaseConfig)config);
            return Stream.of(builder.build());
        };
    }
}

