/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.spanningtree;

import java.util.Map;
import java.util.function.DoubleUnaryOperator;
import java.util.stream.Stream;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.impl.spanningtree.Prim;
import org.neo4j.gds.impl.spanningtree.SpanningTreeConfig;
import org.neo4j.gds.spanningtree.SpanningTreeProc;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@GdsCallable(name="gds.alpha.spanningTree.maximum.write", description="Maximum weight spanning tree visits all nodes that are in the same connected component as the starting node, and returns a spanning tree of all nodes in the component where the total weight of the relationships is maximized.", executionMode=ExecutionMode.WRITE_NODE_PROPERTY)
public class SpanningTreeProcMax
extends SpanningTreeProc {
    static final String MAX_DESCRIPTION = "Maximum weight spanning tree visits all nodes that are in the same connected component as the starting node, and returns a spanning tree of all nodes in the component where the total weight of the relationships is maximized.";

    @Procedure(value="gds.alpha.spanningTree.maximum.write", mode=Mode.WRITE)
    @Description(value="Maximum weight spanning tree visits all nodes that are in the same connected component as the starting node, and returns a spanning tree of all nodes in the component where the total weight of the relationships is maximized.")
    public Stream<Prim.Result> maximumSpanningTree(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        ComputationResult computationResult = this.compute(graphName, configuration);
        return (Stream)this.computationResultConsumer().consume(computationResult, this.executionContext());
    }

    protected SpanningTreeConfig newConfig(String username, CypherMapWrapper config) {
        return SpanningTreeConfig.of((DoubleUnaryOperator)Prim.MAX_OPERATOR, (CypherMapWrapper)config);
    }
}

