/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.spanningtree;

import java.util.stream.Stream;
import org.neo4j.gds.AlgoBaseProc;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.core.utils.ProgressTimer;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.utils.progress.tasks.TaskProgressTracker;
import org.neo4j.gds.core.write.RelationshipExporter;
import org.neo4j.gds.core.write.RelationshipExporterBuilder;
import org.neo4j.gds.executor.ComputationResultConsumer;
import org.neo4j.gds.impl.spanningtree.Prim;
import org.neo4j.gds.impl.spanningtree.SpanningGraph;
import org.neo4j.gds.impl.spanningtree.SpanningTree;
import org.neo4j.gds.impl.spanningtree.SpanningTreeConfig;
import org.neo4j.gds.utils.InputNodeValidator;
import org.neo4j.procedure.Context;

public abstract class SpanningTreeProc
extends AlgoBaseProc<Prim, SpanningTree, SpanningTreeConfig, Prim.Result> {
    @Context
    public RelationshipExporterBuilder<? extends RelationshipExporter> relationshipExporterBuilder;

    public GraphAlgorithmFactory<Prim, SpanningTreeConfig> algorithmFactory() {
        return new GraphAlgorithmFactory<Prim, SpanningTreeConfig>(){

            public String taskName() {
                return "SpanningTree";
            }

            public Prim build(Graph graph, SpanningTreeConfig configuration, ProgressTracker progressTracker) {
                InputNodeValidator.validateStartNode(configuration.startNodeId(), graph);
                return new Prim((IdMap)graph, graph, configuration.minMax(), configuration.startNodeId(), progressTracker);
            }
        };
    }

    public ComputationResultConsumer<Prim, SpanningTree, SpanningTreeConfig, Stream<Prim.Result>> computationResultConsumer() {
        return (computationResult, executionContext) -> {
            Graph graph = computationResult.graph();
            Prim prim = (Prim)computationResult.algorithm();
            SpanningTree spanningTree = (SpanningTree)computationResult.result();
            SpanningTreeConfig config = (SpanningTreeConfig)computationResult.config();
            Prim.Builder builder = new Prim.Builder();
            if (graph.isEmpty()) {
                graph.release();
                return Stream.of(builder.build());
            }
            builder.withEffectiveNodeCount(spanningTree.effectiveNodeCount());
            try (ProgressTimer ignored = ProgressTimer.start(arg_0 -> ((Prim.Builder)builder).withWriteMillis(arg_0));){
                SpanningGraph spanningGraph = new SpanningGraph(graph, spanningTree);
                TaskProgressTracker progressTracker = new TaskProgressTracker(RelationshipExporter.baseTask((String)"SpanningTree", (long)graph.relationshipCount()), this.log, 1, this.taskRegistryFactory);
                this.relationshipExporterBuilder.withGraph((Graph)spanningGraph).withIdMappingOperator(arg_0 -> ((SpanningGraph)spanningGraph).toOriginalNodeId(arg_0)).withTerminationFlag(prim.getTerminationFlag()).withProgressTracker((ProgressTracker)progressTracker).build().write(config.writeProperty(), config.weightWriteProperty());
            }
            builder.withComputeMillis(computationResult.computeMillis());
            builder.withPreProcessingMillis(computationResult.preProcessingMillis());
            return Stream.of(builder.build());
        };
    }
}

