/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.spanningtree;

import java.util.stream.Stream;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.NodePropertiesWriter;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.api.RelationshipProperties;
import org.neo4j.gds.api.properties.nodes.DoubleNodePropertyValues;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.core.concurrency.Pools;
import org.neo4j.gds.core.utils.ProgressTimer;
import org.neo4j.gds.core.utils.TerminationFlag;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.utils.progress.tasks.Task;
import org.neo4j.gds.core.utils.progress.tasks.TaskProgressTracker;
import org.neo4j.gds.core.utils.progress.tasks.Tasks;
import org.neo4j.gds.core.write.NodePropertyExporter;
import org.neo4j.gds.executor.ComputationResultConsumer;
import org.neo4j.gds.impl.spanningtree.KSpanningTree;
import org.neo4j.gds.impl.spanningtree.KSpanningTreeConfig;
import org.neo4j.gds.impl.spanningtree.Prim;
import org.neo4j.gds.impl.spanningtree.SpanningTree;
import org.neo4j.gds.utils.InputNodeValidator;
import org.neo4j.kernel.api.KernelTransaction;

public abstract class KSpanningTreeProc
extends NodePropertiesWriter<KSpanningTree, SpanningTree, KSpanningTreeConfig, Prim.Result> {
    public GraphAlgorithmFactory<KSpanningTree, KSpanningTreeConfig> algorithmFactory() {
        return new GraphAlgorithmFactory<KSpanningTree, KSpanningTreeConfig>(){

            public String taskName() {
                return "KSpanningTree";
            }

            public Task progressTask(Graph graph, KSpanningTreeConfig config) {
                return Tasks.task((String)this.taskName(), (Task)Tasks.leaf((String)"SpanningTree", (long)graph.nodeCount()), (Task[])new Task[]{Tasks.leaf((String)"Add relationship weights"), Tasks.leaf((String)"Remove relationships")});
            }

            public KSpanningTree build(Graph graph, KSpanningTreeConfig configuration, ProgressTracker progressTracker) {
                InputNodeValidator.validateStartNode(configuration.startNodeId(), graph);
                return new KSpanningTree((IdMap)graph, graph, (RelationshipProperties)graph, configuration.minMax(), configuration.startNodeId(), configuration.k(), progressTracker);
            }
        };
    }

    public ComputationResultConsumer<KSpanningTree, SpanningTree, KSpanningTreeConfig, Stream<Prim.Result>> computationResultConsumer() {
        return (computationResult, executionContext) -> {
            Graph graph = computationResult.graph();
            final SpanningTree spanningTree = (SpanningTree)computationResult.result();
            KSpanningTreeConfig config = (KSpanningTreeConfig)computationResult.config();
            Prim.Builder builder = new Prim.Builder();
            if (graph.isEmpty()) {
                graph.release();
                return Stream.of(builder.build());
            }
            builder.withEffectiveNodeCount(spanningTree.effectiveNodeCount());
            try (ProgressTimer ignored = ProgressTimer.start(arg_0 -> ((Prim.Builder)builder).withWriteMillis(arg_0));){
                TaskProgressTracker progressTracker = new TaskProgressTracker(NodePropertyExporter.baseTask((String)"KSpanningTree", (long)graph.nodeCount()), this.log, config.writeConcurrency(), this.taskRegistryFactory);
                NodePropertyExporter exporter = this.nodePropertyExporterBuilder.withIdMap((IdMap)graph).withTerminationFlag(TerminationFlag.wrap((KernelTransaction)this.transaction)).withProgressTracker((ProgressTracker)progressTracker).parallel(Pools.DEFAULT, config.writeConcurrency()).build();
                DoubleNodePropertyValues properties = new DoubleNodePropertyValues(){

                    public long size() {
                        return computationResult.graph().nodeCount();
                    }

                    public double doubleValue(long nodeId) {
                        return spanningTree.head((long)((int)nodeId));
                    }
                };
                exporter.write(config.writeProperty(), (NodePropertyValues)properties);
                builder.withNodePropertiesWritten(exporter.propertiesWritten());
            }
            builder.withComputeMillis(computationResult.computeMillis());
            builder.withPreProcessingMillis(computationResult.preProcessingMillis());
            return Stream.of(builder.build());
        };
    }
}

