/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.influenceMaximization;

import com.carrotsearch.hppc.LongDoubleScatterMap;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.neo4j.gds.MutatePropertyComputationResultConsumer;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.write.ImmutableNodeProperty;
import org.neo4j.gds.core.write.NodeProperty;
import org.neo4j.gds.executor.AlgorithmSpec;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ComputationResultConsumer;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.executor.NewConfigFunction;
import org.neo4j.gds.influenceMaximization.CELF;
import org.neo4j.gds.influenceMaximization.CELFAlgorithmFactory;
import org.neo4j.gds.influenceMaximization.CelfNodeProperties;
import org.neo4j.gds.influenceMaximization.InfluenceMaximizationMutateConfig;
import org.neo4j.gds.influenceMaximization.MutateResult;
import org.neo4j.gds.result.AbstractResultBuilder;

@GdsCallable(name="gds.beta.influenceMaximization.celf.mutate", description="The Cost Effective Lazy Forward (CELF) algorithm aims to find k nodes that maximize the expected spread of influence in the network.", executionMode=ExecutionMode.MUTATE_NODE_PROPERTY)
public class CELFMutateSpec
implements AlgorithmSpec<CELF, LongDoubleScatterMap, InfluenceMaximizationMutateConfig, Stream<MutateResult>, CELFAlgorithmFactory<InfluenceMaximizationMutateConfig>> {
    public String name() {
        return "CELFStream";
    }

    public CELFAlgorithmFactory<InfluenceMaximizationMutateConfig> algorithmFactory() {
        return new CELFAlgorithmFactory();
    }

    public NewConfigFunction<InfluenceMaximizationMutateConfig> newConfigFunction() {
        return (__, userInput) -> InfluenceMaximizationMutateConfig.of((CypherMapWrapper)userInput);
    }

    public ComputationResultConsumer<CELF, LongDoubleScatterMap, InfluenceMaximizationMutateConfig, Stream<MutateResult>> computationResultConsumer() {
        MutatePropertyComputationResultConsumer.MutateNodePropertyListFunction mutateConfigNodePropertyListFunction = computationResult -> {
            LongDoubleScatterMap celfSeedSet = (LongDoubleScatterMap)computationResult.result();
            long nodeCount = computationResult.graph().nodeCount();
            NodeProperty celfSeedSetNodeProperty = ImmutableNodeProperty.of((String)((InfluenceMaximizationMutateConfig)computationResult.config()).mutateProperty(), (NodePropertyValues)new CelfNodeProperties(celfSeedSet, nodeCount));
            return List.of(celfSeedSetNodeProperty);
        };
        return new MutatePropertyComputationResultConsumer(mutateConfigNodePropertyListFunction, this::resultBuilder);
    }

    @NotNull
    private AbstractResultBuilder<MutateResult> resultBuilder(ComputationResult<CELF, LongDoubleScatterMap, InfluenceMaximizationMutateConfig> computationResult, ExecutionContext executionContext) {
        return MutateResult.builder().withTotalSpread(Arrays.stream(((LongDoubleScatterMap)computationResult.result()).values).sum()).withNodeCount(computationResult.graph().nodeCount()).withComputeMillis(computationResult.computeMillis()).withConfig(computationResult.config());
    }
}

