/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.centrality;

import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.config.MutatePropertyConfig;
import org.neo4j.gds.config.WritePropertyConfig;
import org.neo4j.gds.result.AbstractCentralityResultBuilder;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;

class CentralityScore {
    public final long nodeId;
    public final Double score;

    public CentralityScore(long nodeId, Double score) {
        this.nodeId = nodeId;
        this.score = score;
    }

    public static class Mutate {
        public final long nodes;
        public final long preProcessingMillis;
        public final long computeMillis;
        public final long mutateMillis;
        public final String mutateProperty;
        public final Map<String, Object> centralityDistribution;

        public Mutate(long nodes, long preProcessingMillis, long computeMillis, long mutateMillis, String mutateProperty, @Nullable Map<String, Object> centralityDistribution) {
            this.nodes = nodes;
            this.preProcessingMillis = preProcessingMillis;
            this.computeMillis = computeMillis;
            this.mutateMillis = mutateMillis;
            this.mutateProperty = mutateProperty;
            this.centralityDistribution = centralityDistribution;
        }

        public static final class Builder
        extends AbstractCentralityResultBuilder<Mutate> {
            public Builder(ProcedureCallContext callContext, int concurrency) {
                super(callContext, concurrency);
            }

            public Mutate buildResult() {
                return new Mutate(this.nodeCount, this.preProcessingMillis, this.computeMillis, this.writeMillis, this.config instanceof MutatePropertyConfig ? ((MutatePropertyConfig)this.config).mutateProperty() : "", this.centralityHistogram);
            }
        }
    }

    public static class Stats {
        public final long nodes;
        public final long preProcessingMillis;
        public final long computeMillis;
        public final long writeMillis;
        public final String writeProperty;
        public final Map<String, Object> centralityDistribution;

        public Stats(long nodes, long preProcessingMillis, long computeMillis, long writeMillis, String writeProperty, @Nullable Map<String, Object> centralityDistribution) {
            this.nodes = nodes;
            this.preProcessingMillis = preProcessingMillis;
            this.computeMillis = computeMillis;
            this.writeMillis = writeMillis;
            this.writeProperty = writeProperty;
            this.centralityDistribution = centralityDistribution;
        }

        public static final class Builder
        extends AbstractCentralityResultBuilder<Stats> {
            public Builder(ProcedureCallContext callContext, int concurrency) {
                super(callContext, concurrency);
            }

            public Stats buildResult() {
                return new Stats(this.nodeCount, this.preProcessingMillis, this.computeMillis, this.writeMillis, this.config instanceof WritePropertyConfig ? ((WritePropertyConfig)this.config).writeProperty() : "", this.centralityHistogram);
            }
        }
    }
}

