/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.scc;

import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.NodePropertiesWriter;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.impl.scc.SccAlgorithm;
import org.neo4j.gds.impl.scc.SccConfig;

public abstract class SccProc<PROC_RESULT>
extends NodePropertiesWriter<SccAlgorithm, HugeLongArray, SccConfig, PROC_RESULT> {
    protected static final String DESCRIPTION = "The SCC algorithm finds sets of connected nodes in an directed graph, where all nodes in the same set form a connected component.";

    protected SccConfig newConfig(String username, CypherMapWrapper config) {
        return SccConfig.of((CypherMapWrapper)config);
    }

    public GraphAlgorithmFactory<SccAlgorithm, SccConfig> algorithmFactory() {
        return new GraphAlgorithmFactory<SccAlgorithm, SccConfig>(){

            public String taskName() {
                return "Scc";
            }

            public SccAlgorithm build(Graph graph, SccConfig configuration, ProgressTracker progressTracker) {
                return new SccAlgorithm(graph, progressTracker);
            }
        };
    }
}

