/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.influenceMaximization;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.AlgoBaseProc;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.concurrency.Pools;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ComputationResultConsumer;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.influenceMaximization.Greedy;
import org.neo4j.gds.influenceMaximization.InfluenceMaximizationConfig;
import org.neo4j.gds.influenceMaximization.InfluenceMaximizationConfigImpl;
import org.neo4j.gds.influenceMaximization.InfluenceMaximizationResult;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@GdsCallable(name="gds.alpha.influenceMaximization.greedy.stream", description="The Greedy algorithm aims to find k nodes that maximize the expected spread of influence in the network.", executionMode=ExecutionMode.STREAM)
public class GreedyProc
extends AlgoBaseProc<Greedy, Greedy, InfluenceMaximizationConfig, InfluenceMaximizationResult> {
    public static final String DESCRIPTION = "The Greedy algorithm aims to find k nodes that maximize the expected spread of influence in the network.";

    @Procedure(name="gds.alpha.influenceMaximization.greedy.stream", mode=Mode.READ)
    @Description(value="The Greedy algorithm aims to find k nodes that maximize the expected spread of influence in the network.")
    public Stream<InfluenceMaximizationResult> stream(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        ComputationResult computationResult = this.compute(graphName, configuration);
        return (Stream)this.computationResultConsumer().consume(computationResult, this.executionContext());
    }

    protected InfluenceMaximizationConfig newConfig(String username, CypherMapWrapper config) {
        return new InfluenceMaximizationConfigImpl(config);
    }

    public GraphAlgorithmFactory<Greedy, InfluenceMaximizationConfig> algorithmFactory() {
        return new GraphAlgorithmFactory<Greedy, InfluenceMaximizationConfig>(){

            public String taskName() {
                return "Greedy";
            }

            public Greedy build(Graph graph, InfluenceMaximizationConfig configuration, ProgressTracker progressTracker) {
                return new Greedy(graph, configuration.seedSetSize(), configuration.propagationProbability(), configuration.monteCarloSimulations(), Pools.DEFAULT, configuration.concurrency());
            }
        };
    }

    public ComputationResultConsumer<Greedy, Greedy, InfluenceMaximizationConfig, Stream<InfluenceMaximizationResult>> computationResultConsumer() {
        return (computationResult, executionContext) -> {
            if (computationResult.graph().isEmpty()) {
                computationResult.graph().release();
                return Stream.empty();
            }
            computationResult.graph().release();
            return ((Greedy)computationResult.algorithm()).resultStream();
        };
    }
}

