/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.walking;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.gds.GraphStoreAlgorithmFactory;
import org.neo4j.gds.MutateComputationResultConsumer;
import org.neo4j.gds.MutateProc;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.Relationships;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.utils.ProgressTimer;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.impl.walking.CollapsePath;
import org.neo4j.gds.impl.walking.CollapsePathAlgorithmFactory;
import org.neo4j.gds.impl.walking.CollapsePathConfig;
import org.neo4j.gds.result.AbstractResultBuilder;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@GdsCallable(name="gds.alpha.collapsePath.mutate", description="Collapse Path algorithm is a traversal algorithm capable of creating relationships between the start and end nodes of a traversal", executionMode=ExecutionMode.MUTATE_RELATIONSHIP)
public class CollapsePathMutateProc
extends MutateProc<CollapsePath, Relationships, MutateResult, CollapsePathConfig> {
    static final String DESCRIPTION = "Collapse Path algorithm is a traversal algorithm capable of creating relationships between the start and end nodes of a traversal";

    @Procedure(name="gds.alpha.collapsePath.mutate", mode=Mode.READ)
    @Description(value="Collapse Path algorithm is a traversal algorithm capable of creating relationships between the start and end nodes of a traversal")
    public Stream<MutateResult> mutate(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        ComputationResult computationResult = this.compute(graphName, configuration, true, false);
        return this.computationResultConsumer().consume(computationResult, this.executionContext());
    }

    protected CollapsePathConfig newConfig(String username, CypherMapWrapper config) {
        return CollapsePathConfig.of((CypherMapWrapper)config);
    }

    public MutateComputationResultConsumer<CollapsePath, Relationships, CollapsePathConfig, MutateResult> computationResultConsumer() {
        return new MutateComputationResultConsumer<CollapsePath, Relationships, CollapsePathConfig, MutateResult>(this::resultBuilder){

            protected void updateGraphStore(AbstractResultBuilder<?> resultBuilder, ComputationResult<CollapsePath, Relationships, CollapsePathConfig> computationResult, ExecutionContext executionContext) {
                try (ProgressTimer ignored = ProgressTimer.start(arg_0 -> resultBuilder.withMutateMillis(arg_0));){
                    computationResult.graphStore().addRelationshipType(RelationshipType.of((String)((CollapsePathConfig)computationResult.config()).mutateRelationshipType()), Optional.empty(), Optional.empty(), (Relationships)computationResult.result());
                }
                resultBuilder.withRelationshipsWritten(((Relationships)computationResult.result()).topology().elementCount());
            }
        };
    }

    public GraphStoreAlgorithmFactory<CollapsePath, CollapsePathConfig> algorithmFactory() {
        return new CollapsePathAlgorithmFactory();
    }

    protected AbstractResultBuilder<MutateResult> resultBuilder(ComputationResult<CollapsePath, Relationships, CollapsePathConfig> computeResult, ExecutionContext executionContext) {
        return new MutateResult.Builder();
    }

    public static class MutateResult {
        public final long preProcessingMillis;
        public final long computeMillis;
        public final long mutateMillis;
        public final long relationshipsWritten;
        public final Map<String, Object> configuration;

        MutateResult(long preProcessingMillis, long computeMillis, long mutateMillis, long relationshipsWritten, Map<String, Object> configuration) {
            this.preProcessingMillis = preProcessingMillis;
            this.computeMillis = computeMillis;
            this.mutateMillis = mutateMillis;
            this.relationshipsWritten = relationshipsWritten;
            this.configuration = configuration;
        }

        static class Builder
        extends AbstractResultBuilder<MutateResult> {
            Builder() {
            }

            public MutateResult build() {
                return new MutateResult(this.preProcessingMillis, this.computeMillis, this.mutateMillis, this.relationshipsWritten, this.config.toMap());
            }
        }
    }
}

