/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.pregel;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.beta.pregel.Pregel;
import org.neo4j.gds.beta.pregel.PregelConfig;
import org.neo4j.gds.beta.pregel.PregelSchema;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.utils.progress.tasks.Task;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.pregel.SpeakerListenerLPA;
import org.neo4j.gds.pregel.SpeakerListenerLPAAlgorithm;
import org.neo4j.gds.pregel.proc.PregelStreamProc;
import org.neo4j.gds.pregel.proc.PregelStreamResult;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@GdsCallable(name="gds.alpha.sllpa.stream", executionMode=ExecutionMode.STREAM, description="The Speaker Listener Label Propagation algorithm is a fast algorithm for finding overlapping communities in a graph.")
public final class SpeakerListenerLPAStreamProc
extends PregelStreamProc<SpeakerListenerLPAAlgorithm, SpeakerListenerLPA.SpeakerListenerLPAConfig> {
    @Procedure(name="gds.alpha.sllpa.stream", mode=Mode.READ)
    @Description(value="The Speaker Listener Label Propagation algorithm is a fast algorithm for finding overlapping communities in a graph.")
    public Stream<PregelStreamResult> stream(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.stream(this.compute(graphName, configuration));
    }

    @Procedure(name="gds.alpha.sllpa.stream.estimate", mode=Mode.READ)
    @Description(value="Returns an estimation of the memory consumption for that procedure.")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphNameOrConfiguration") Object graphNameOrConfiguration, @Name(value="algoConfiguration") Map<String, Object> algoConfiguration) {
        return this.computeEstimate(graphNameOrConfiguration, algoConfiguration);
    }

    protected PregelStreamResult streamResult(long originalNodeId, long internalNodeId, NodePropertyValues nodePropertyValues) {
        throw new UnsupportedOperationException();
    }

    protected SpeakerListenerLPA.SpeakerListenerLPAConfig newConfig(String username, CypherMapWrapper config) {
        return SpeakerListenerLPA.SpeakerListenerLPAConfig.of(config);
    }

    public GraphAlgorithmFactory<SpeakerListenerLPAAlgorithm, SpeakerListenerLPA.SpeakerListenerLPAConfig> algorithmFactory() {
        return new GraphAlgorithmFactory<SpeakerListenerLPAAlgorithm, SpeakerListenerLPA.SpeakerListenerLPAConfig>(){

            public SpeakerListenerLPAAlgorithm build(Graph graph, SpeakerListenerLPA.SpeakerListenerLPAConfig configuration, ProgressTracker progressTracker) {
                return new SpeakerListenerLPAAlgorithm(graph, configuration, progressTracker);
            }

            public String taskName() {
                return SpeakerListenerLPAAlgorithm.class.getSimpleName();
            }

            public Task progressTask(Graph graph, SpeakerListenerLPA.SpeakerListenerLPAConfig configuration) {
                return Pregel.progressTask((Graph)graph, (PregelConfig)configuration);
            }

            public MemoryEstimation memoryEstimation(SpeakerListenerLPA.SpeakerListenerLPAConfig configuration) {
                SpeakerListenerLPA computation = new SpeakerListenerLPA();
                return Pregel.memoryEstimation((PregelSchema)computation.schema(configuration), (boolean)computation.reducer().isEmpty(), (boolean)configuration.isAsynchronous());
            }
        };
    }
}

