/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.pregel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.beta.pregel.Partitioning;
import org.neo4j.gds.beta.pregel.PregelConfig;
import org.neo4j.gds.beta.pregel.PregelProcedureConfig;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.config.ConcurrencyConfig;
import org.neo4j.gds.config.IterationsConfig;
import org.neo4j.gds.config.JobIdConfig;
import org.neo4j.gds.config.MutatePropertyConfig;
import org.neo4j.gds.config.RelationshipWeightConfig;
import org.neo4j.gds.config.WriteConfig;
import org.neo4j.gds.config.WritePropertyConfig;
import org.neo4j.gds.core.utils.progress.JobId;
import org.neo4j.gds.pregel.SpeakerListenerLPA;

@ParametersAreNonnullByDefault
@Generated(from="SpeakerListenerLPA.SpeakerListenerLPAConfig", generator="Immutables")
@Immutable
public final class ImmutableSpeakerListenerLPAConfig
implements SpeakerListenerLPA.SpeakerListenerLPAConfig {
    @Nullable
    private final String usernameOverride;
    private final boolean sudo;
    private final Collection<String> configKeys;
    private final transient Map<String, Object> toMap;
    private final int concurrency;
    private final int minBatchSize;
    private final JobId jobId;
    private final List<String> relationshipTypes;
    private final List<String> nodeLabels;
    @Nullable
    private final String relationshipWeightProperty;
    private final transient boolean hasRelationshipWeightProperty;
    private final int maxIterations;
    private final Partitioning partitioning;
    private final transient boolean useForkJoin;
    private final int writeConcurrency;
    private final String writeProperty;
    private final String mutateProperty;
    private final double minAssociationStrength;
    private final transient boolean isAsynchronous;
    private final transient int propagationSteps;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableSpeakerListenerLPAConfig(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, @Nullable String relationshipWeightProperty, int maxIterations, Partitioning partitioning, int writeConcurrency, String writeProperty, String mutateProperty, double minAssociationStrength) {
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.relationshipTypes(ImmutableSpeakerListenerLPAConfig.createUnmodifiableList(false, ImmutableSpeakerListenerLPAConfig.createSafeList(relationshipTypes, true, false)));
        this.initShim.nodeLabels(ImmutableSpeakerListenerLPAConfig.createUnmodifiableList(false, ImmutableSpeakerListenerLPAConfig.createSafeList(nodeLabels, true, false)));
        this.initShim.relationshipWeightProperty(relationshipWeightProperty);
        this.maxIterations = maxIterations;
        this.initShim.partitioning(Objects.requireNonNull(partitioning, "partitioning"));
        this.initShim.writeConcurrency(writeConcurrency);
        this.initShim.writeProperty(Objects.requireNonNull(writeProperty, "writeProperty"));
        this.initShim.mutateProperty(Objects.requireNonNull(mutateProperty, "mutateProperty"));
        this.initShim.minAssociationStrength(minAssociationStrength);
        this.usernameOverride = this.initShim.usernameOverride();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.jobId = this.initShim.jobId();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.relationshipWeightProperty = this.initShim.relationshipWeightProperty();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.partitioning = this.initShim.partitioning();
        this.useForkJoin = this.initShim.useForkJoin();
        this.writeConcurrency = this.initShim.writeConcurrency();
        this.writeProperty = this.initShim.writeProperty();
        this.mutateProperty = this.initShim.mutateProperty();
        this.minAssociationStrength = this.initShim.minAssociationStrength();
        this.isAsynchronous = this.initShim.isAsynchronous();
        this.propagationSteps = this.initShim.propagationSteps();
        this.initShim = null;
    }

    private ImmutableSpeakerListenerLPAConfig(Builder builder) {
        this.maxIterations = builder.maxIterations;
        if (builder.usernameOverrideIsSet()) {
            this.initShim.usernameOverride(builder.usernameOverride);
        }
        if (builder.sudoIsSet()) {
            this.initShim.sudo(builder.sudo);
        }
        if (builder.configKeys != null) {
            this.initShim.configKeys(builder.configKeys);
        }
        if (builder.concurrencyIsSet()) {
            this.initShim.concurrency(builder.concurrency);
        }
        if (builder.minBatchSizeIsSet()) {
            this.initShim.minBatchSize(builder.minBatchSize);
        }
        if (builder.jobId != null) {
            this.initShim.jobId(builder.jobId);
        }
        if (builder.relationshipTypesIsSet()) {
            this.initShim.relationshipTypes(builder.relationshipTypes == null ? Collections.emptyList() : ImmutableSpeakerListenerLPAConfig.createUnmodifiableList(true, builder.relationshipTypes));
        }
        if (builder.nodeLabelsIsSet()) {
            this.initShim.nodeLabels(builder.nodeLabels == null ? Collections.emptyList() : ImmutableSpeakerListenerLPAConfig.createUnmodifiableList(true, builder.nodeLabels));
        }
        if (builder.relationshipWeightPropertyIsSet()) {
            this.initShim.relationshipWeightProperty(builder.relationshipWeightProperty);
        }
        if (builder.partitioning != null) {
            this.initShim.partitioning(builder.partitioning);
        }
        if (builder.writeConcurrencyIsSet()) {
            this.initShim.writeConcurrency(builder.writeConcurrency);
        }
        if (builder.writeProperty != null) {
            this.initShim.writeProperty(builder.writeProperty);
        }
        if (builder.mutateProperty != null) {
            this.initShim.mutateProperty(builder.mutateProperty);
        }
        if (builder.minAssociationStrengthIsSet()) {
            this.initShim.minAssociationStrength(builder.minAssociationStrength);
        }
        this.usernameOverride = this.initShim.usernameOverride();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.jobId = this.initShim.jobId();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.relationshipWeightProperty = this.initShim.relationshipWeightProperty();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.partitioning = this.initShim.partitioning();
        this.useForkJoin = this.initShim.useForkJoin();
        this.writeConcurrency = this.initShim.writeConcurrency();
        this.writeProperty = this.initShim.writeProperty();
        this.mutateProperty = this.initShim.mutateProperty();
        this.minAssociationStrength = this.initShim.minAssociationStrength();
        this.isAsynchronous = this.initShim.isAsynchronous();
        this.propagationSteps = this.initShim.propagationSteps();
        this.initShim = null;
    }

    private ImmutableSpeakerListenerLPAConfig(@Nullable String usernameOverride, boolean sudo, Collection<String> configKeys, int concurrency, int minBatchSize, JobId jobId, List<String> relationshipTypes, List<String> nodeLabels, @Nullable String relationshipWeightProperty, int maxIterations, Partitioning partitioning, int writeConcurrency, String writeProperty, String mutateProperty, double minAssociationStrength) {
        this.initShim.usernameOverride(usernameOverride);
        this.initShim.sudo(sudo);
        this.initShim.configKeys(configKeys);
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.jobId(jobId);
        this.initShim.relationshipTypes(relationshipTypes);
        this.initShim.nodeLabels(nodeLabels);
        this.initShim.relationshipWeightProperty(relationshipWeightProperty);
        this.maxIterations = maxIterations;
        this.initShim.partitioning(partitioning);
        this.initShim.writeConcurrency(writeConcurrency);
        this.initShim.writeProperty(writeProperty);
        this.initShim.mutateProperty(mutateProperty);
        this.initShim.minAssociationStrength(minAssociationStrength);
        this.usernameOverride = this.initShim.usernameOverride();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.jobId = this.initShim.jobId();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.relationshipWeightProperty = this.initShim.relationshipWeightProperty();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.partitioning = this.initShim.partitioning();
        this.useForkJoin = this.initShim.useForkJoin();
        this.writeConcurrency = this.initShim.writeConcurrency();
        this.writeProperty = this.initShim.writeProperty();
        this.mutateProperty = this.initShim.mutateProperty();
        this.minAssociationStrength = this.initShim.minAssociationStrength();
        this.isAsynchronous = this.initShim.isAsynchronous();
        this.propagationSteps = this.initShim.propagationSteps();
        this.initShim = null;
    }

    @Nullable
    private String usernameOverrideInitialize() {
        return SpeakerListenerLPA.SpeakerListenerLPAConfig.super.usernameOverride();
    }

    private boolean sudoInitialize() {
        return SpeakerListenerLPA.SpeakerListenerLPAConfig.super.sudo();
    }

    private Collection<String> configKeysInitialize() {
        return SpeakerListenerLPA.SpeakerListenerLPAConfig.super.configKeys();
    }

    private Map<String, Object> toMapInitialize() {
        return SpeakerListenerLPA.SpeakerListenerLPAConfig.super.toMap();
    }

    private int concurrencyInitialize() {
        return SpeakerListenerLPA.SpeakerListenerLPAConfig.super.concurrency();
    }

    private int minBatchSizeInitialize() {
        return SpeakerListenerLPA.SpeakerListenerLPAConfig.super.minBatchSize();
    }

    private JobId jobIdInitialize() {
        return SpeakerListenerLPA.SpeakerListenerLPAConfig.super.jobId();
    }

    private List<String> relationshipTypesInitialize() {
        return SpeakerListenerLPA.SpeakerListenerLPAConfig.super.relationshipTypes();
    }

    private List<String> nodeLabelsInitialize() {
        return SpeakerListenerLPA.SpeakerListenerLPAConfig.super.nodeLabels();
    }

    @Nullable
    private String relationshipWeightPropertyInitialize() {
        return SpeakerListenerLPA.SpeakerListenerLPAConfig.super.relationshipWeightProperty();
    }

    private boolean hasRelationshipWeightPropertyInitialize() {
        return SpeakerListenerLPA.SpeakerListenerLPAConfig.super.hasRelationshipWeightProperty();
    }

    private Partitioning partitioningInitialize() {
        return SpeakerListenerLPA.SpeakerListenerLPAConfig.super.partitioning();
    }

    private boolean useForkJoinInitialize() {
        return SpeakerListenerLPA.SpeakerListenerLPAConfig.super.useForkJoin();
    }

    private int writeConcurrencyInitialize() {
        return SpeakerListenerLPA.SpeakerListenerLPAConfig.super.writeConcurrency();
    }

    private String writePropertyInitialize() {
        return SpeakerListenerLPA.SpeakerListenerLPAConfig.super.writeProperty();
    }

    private String mutatePropertyInitialize() {
        return SpeakerListenerLPA.SpeakerListenerLPAConfig.super.mutateProperty();
    }

    private double minAssociationStrengthInitialize() {
        return SpeakerListenerLPA.SpeakerListenerLPAConfig.super.minAssociationStrength();
    }

    private boolean isAsynchronousInitialize() {
        return SpeakerListenerLPA.SpeakerListenerLPAConfig.super.isAsynchronous();
    }

    private int propagationStepsInitialize() {
        return SpeakerListenerLPA.SpeakerListenerLPAConfig.super.propagationSteps();
    }

    @Nullable
    public String usernameOverride() {
        InitShim shim = this.initShim;
        return shim != null ? shim.usernameOverride() : this.usernameOverride;
    }

    public boolean sudo() {
        InitShim shim = this.initShim;
        return shim != null ? shim.sudo() : this.sudo;
    }

    public Collection<String> configKeys() {
        InitShim shim = this.initShim;
        return shim != null ? shim.configKeys() : this.configKeys;
    }

    public Map<String, Object> toMap() {
        InitShim shim = this.initShim;
        return shim != null ? shim.toMap() : this.toMap;
    }

    public int concurrency() {
        InitShim shim = this.initShim;
        return shim != null ? shim.concurrency() : this.concurrency;
    }

    public int minBatchSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.minBatchSize() : this.minBatchSize;
    }

    public JobId jobId() {
        InitShim shim = this.initShim;
        return shim != null ? shim.jobId() : this.jobId;
    }

    public List<String> relationshipTypes() {
        InitShim shim = this.initShim;
        return shim != null ? shim.relationshipTypes() : this.relationshipTypes;
    }

    public List<String> nodeLabels() {
        InitShim shim = this.initShim;
        return shim != null ? shim.nodeLabels() : this.nodeLabels;
    }

    @Nullable
    public String relationshipWeightProperty() {
        InitShim shim = this.initShim;
        return shim != null ? shim.relationshipWeightProperty() : this.relationshipWeightProperty;
    }

    public boolean hasRelationshipWeightProperty() {
        InitShim shim = this.initShim;
        return shim != null ? shim.hasRelationshipWeightProperty() : this.hasRelationshipWeightProperty;
    }

    public int maxIterations() {
        return this.maxIterations;
    }

    public Partitioning partitioning() {
        InitShim shim = this.initShim;
        return shim != null ? shim.partitioning() : this.partitioning;
    }

    public boolean useForkJoin() {
        InitShim shim = this.initShim;
        return shim != null ? shim.useForkJoin() : this.useForkJoin;
    }

    public int writeConcurrency() {
        InitShim shim = this.initShim;
        return shim != null ? shim.writeConcurrency() : this.writeConcurrency;
    }

    public String writeProperty() {
        InitShim shim = this.initShim;
        return shim != null ? shim.writeProperty() : this.writeProperty;
    }

    public String mutateProperty() {
        InitShim shim = this.initShim;
        return shim != null ? shim.mutateProperty() : this.mutateProperty;
    }

    @Override
    public double minAssociationStrength() {
        InitShim shim = this.initShim;
        return shim != null ? shim.minAssociationStrength() : this.minAssociationStrength;
    }

    @Override
    public boolean isAsynchronous() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isAsynchronous() : this.isAsynchronous;
    }

    @Override
    public int propagationSteps() {
        InitShim shim = this.initShim;
        return shim != null ? shim.propagationSteps() : this.propagationSteps;
    }

    public final ImmutableSpeakerListenerLPAConfig withUsernameOverride(@Nullable String value) {
        if (Objects.equals(this.usernameOverride, value)) {
            return this;
        }
        return ImmutableSpeakerListenerLPAConfig.validate(new ImmutableSpeakerListenerLPAConfig(value, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.maxIterations, this.partitioning, this.writeConcurrency, this.writeProperty, this.mutateProperty, this.minAssociationStrength));
    }

    public final ImmutableSpeakerListenerLPAConfig withSudo(boolean value) {
        if (this.sudo == value) {
            return this;
        }
        return ImmutableSpeakerListenerLPAConfig.validate(new ImmutableSpeakerListenerLPAConfig(this.usernameOverride, value, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.maxIterations, this.partitioning, this.writeConcurrency, this.writeProperty, this.mutateProperty, this.minAssociationStrength));
    }

    public final ImmutableSpeakerListenerLPAConfig withConfigKeys(Collection<String> value) {
        if (this.configKeys == value) {
            return this;
        }
        Collection<String> newValue = Objects.requireNonNull(value, "configKeys");
        return ImmutableSpeakerListenerLPAConfig.validate(new ImmutableSpeakerListenerLPAConfig(this.usernameOverride, this.sudo, newValue, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.maxIterations, this.partitioning, this.writeConcurrency, this.writeProperty, this.mutateProperty, this.minAssociationStrength));
    }

    public final ImmutableSpeakerListenerLPAConfig withConcurrency(int value) {
        if (this.concurrency == value) {
            return this;
        }
        return ImmutableSpeakerListenerLPAConfig.validate(new ImmutableSpeakerListenerLPAConfig(this.usernameOverride, this.sudo, this.configKeys, value, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.maxIterations, this.partitioning, this.writeConcurrency, this.writeProperty, this.mutateProperty, this.minAssociationStrength));
    }

    public final ImmutableSpeakerListenerLPAConfig withMinBatchSize(int value) {
        if (this.minBatchSize == value) {
            return this;
        }
        return ImmutableSpeakerListenerLPAConfig.validate(new ImmutableSpeakerListenerLPAConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, value, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.maxIterations, this.partitioning, this.writeConcurrency, this.writeProperty, this.mutateProperty, this.minAssociationStrength));
    }

    public final ImmutableSpeakerListenerLPAConfig withJobId(JobId value) {
        if (this.jobId == value) {
            return this;
        }
        JobId newValue = Objects.requireNonNull(value, "jobId");
        return ImmutableSpeakerListenerLPAConfig.validate(new ImmutableSpeakerListenerLPAConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, newValue, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.maxIterations, this.partitioning, this.writeConcurrency, this.writeProperty, this.mutateProperty, this.minAssociationStrength));
    }

    public final ImmutableSpeakerListenerLPAConfig withRelationshipTypes(String ... elements) {
        List<String> newValue = ImmutableSpeakerListenerLPAConfig.createUnmodifiableList(false, ImmutableSpeakerListenerLPAConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableSpeakerListenerLPAConfig.validate(new ImmutableSpeakerListenerLPAConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, newValue, this.nodeLabels, this.relationshipWeightProperty, this.maxIterations, this.partitioning, this.writeConcurrency, this.writeProperty, this.mutateProperty, this.minAssociationStrength));
    }

    public final ImmutableSpeakerListenerLPAConfig withRelationshipTypes(Iterable<String> elements) {
        if (this.relationshipTypes == elements) {
            return this;
        }
        List<String> newValue = ImmutableSpeakerListenerLPAConfig.createUnmodifiableList(false, ImmutableSpeakerListenerLPAConfig.createSafeList(elements, true, false));
        return ImmutableSpeakerListenerLPAConfig.validate(new ImmutableSpeakerListenerLPAConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, newValue, this.nodeLabels, this.relationshipWeightProperty, this.maxIterations, this.partitioning, this.writeConcurrency, this.writeProperty, this.mutateProperty, this.minAssociationStrength));
    }

    public final ImmutableSpeakerListenerLPAConfig withNodeLabels(String ... elements) {
        List<String> newValue = ImmutableSpeakerListenerLPAConfig.createUnmodifiableList(false, ImmutableSpeakerListenerLPAConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableSpeakerListenerLPAConfig.validate(new ImmutableSpeakerListenerLPAConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, newValue, this.relationshipWeightProperty, this.maxIterations, this.partitioning, this.writeConcurrency, this.writeProperty, this.mutateProperty, this.minAssociationStrength));
    }

    public final ImmutableSpeakerListenerLPAConfig withNodeLabels(Iterable<String> elements) {
        if (this.nodeLabels == elements) {
            return this;
        }
        List<String> newValue = ImmutableSpeakerListenerLPAConfig.createUnmodifiableList(false, ImmutableSpeakerListenerLPAConfig.createSafeList(elements, true, false));
        return ImmutableSpeakerListenerLPAConfig.validate(new ImmutableSpeakerListenerLPAConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, newValue, this.relationshipWeightProperty, this.maxIterations, this.partitioning, this.writeConcurrency, this.writeProperty, this.mutateProperty, this.minAssociationStrength));
    }

    public final ImmutableSpeakerListenerLPAConfig withRelationshipWeightProperty(@Nullable String value) {
        if (Objects.equals(this.relationshipWeightProperty, value)) {
            return this;
        }
        return ImmutableSpeakerListenerLPAConfig.validate(new ImmutableSpeakerListenerLPAConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, value, this.maxIterations, this.partitioning, this.writeConcurrency, this.writeProperty, this.mutateProperty, this.minAssociationStrength));
    }

    public final ImmutableSpeakerListenerLPAConfig withMaxIterations(int value) {
        if (this.maxIterations == value) {
            return this;
        }
        return ImmutableSpeakerListenerLPAConfig.validate(new ImmutableSpeakerListenerLPAConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, value, this.partitioning, this.writeConcurrency, this.writeProperty, this.mutateProperty, this.minAssociationStrength));
    }

    public final ImmutableSpeakerListenerLPAConfig withPartitioning(Partitioning value) {
        if (this.partitioning == value) {
            return this;
        }
        Partitioning newValue = Objects.requireNonNull(value, "partitioning");
        if (this.partitioning.equals((Object)newValue)) {
            return this;
        }
        return ImmutableSpeakerListenerLPAConfig.validate(new ImmutableSpeakerListenerLPAConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.maxIterations, newValue, this.writeConcurrency, this.writeProperty, this.mutateProperty, this.minAssociationStrength));
    }

    public final ImmutableSpeakerListenerLPAConfig withWriteConcurrency(int value) {
        if (this.writeConcurrency == value) {
            return this;
        }
        return ImmutableSpeakerListenerLPAConfig.validate(new ImmutableSpeakerListenerLPAConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.maxIterations, this.partitioning, value, this.writeProperty, this.mutateProperty, this.minAssociationStrength));
    }

    public final ImmutableSpeakerListenerLPAConfig withWriteProperty(String value) {
        String newValue = Objects.requireNonNull(value, "writeProperty");
        if (this.writeProperty.equals(newValue)) {
            return this;
        }
        return ImmutableSpeakerListenerLPAConfig.validate(new ImmutableSpeakerListenerLPAConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.maxIterations, this.partitioning, this.writeConcurrency, newValue, this.mutateProperty, this.minAssociationStrength));
    }

    public final ImmutableSpeakerListenerLPAConfig withMutateProperty(String value) {
        String newValue = Objects.requireNonNull(value, "mutateProperty");
        if (this.mutateProperty.equals(newValue)) {
            return this;
        }
        return ImmutableSpeakerListenerLPAConfig.validate(new ImmutableSpeakerListenerLPAConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.maxIterations, this.partitioning, this.writeConcurrency, this.writeProperty, newValue, this.minAssociationStrength));
    }

    public final ImmutableSpeakerListenerLPAConfig withMinAssociationStrength(double value) {
        if (Double.doubleToLongBits(this.minAssociationStrength) == Double.doubleToLongBits(value)) {
            return this;
        }
        return ImmutableSpeakerListenerLPAConfig.validate(new ImmutableSpeakerListenerLPAConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.maxIterations, this.partitioning, this.writeConcurrency, this.writeProperty, this.mutateProperty, value));
    }

    public boolean equals(@javax.annotation.Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSpeakerListenerLPAConfig && this.equalTo((ImmutableSpeakerListenerLPAConfig)another);
    }

    private boolean equalTo(ImmutableSpeakerListenerLPAConfig another) {
        return Objects.equals(this.usernameOverride, another.usernameOverride) && this.sudo == another.sudo && this.concurrency == another.concurrency && this.minBatchSize == another.minBatchSize && this.jobId.equals((Object)another.jobId) && this.relationshipTypes.equals(another.relationshipTypes) && this.nodeLabels.equals(another.nodeLabels) && Objects.equals(this.relationshipWeightProperty, another.relationshipWeightProperty) && this.hasRelationshipWeightProperty == another.hasRelationshipWeightProperty && this.maxIterations == another.maxIterations && this.partitioning.equals((Object)another.partitioning) && this.useForkJoin == another.useForkJoin && this.writeConcurrency == another.writeConcurrency && this.writeProperty.equals(another.writeProperty) && this.mutateProperty.equals(another.mutateProperty) && Double.doubleToLongBits(this.minAssociationStrength) == Double.doubleToLongBits(another.minAssociationStrength) && this.isAsynchronous == another.isAsynchronous && this.propagationSteps == another.propagationSteps;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.usernameOverride);
        h += (h << 5) + Boolean.hashCode(this.sudo);
        h += (h << 5) + this.concurrency;
        h += (h << 5) + this.minBatchSize;
        h += (h << 5) + this.jobId.hashCode();
        h += (h << 5) + this.relationshipTypes.hashCode();
        h += (h << 5) + this.nodeLabels.hashCode();
        h += (h << 5) + Objects.hashCode(this.relationshipWeightProperty);
        h += (h << 5) + Boolean.hashCode(this.hasRelationshipWeightProperty);
        h += (h << 5) + this.maxIterations;
        h += (h << 5) + this.partitioning.hashCode();
        h += (h << 5) + Boolean.hashCode(this.useForkJoin);
        h += (h << 5) + this.writeConcurrency;
        h += (h << 5) + this.writeProperty.hashCode();
        h += (h << 5) + this.mutateProperty.hashCode();
        h += (h << 5) + Double.hashCode(this.minAssociationStrength);
        h += (h << 5) + Boolean.hashCode(this.isAsynchronous);
        h += (h << 5) + this.propagationSteps;
        return h;
    }

    public String toString() {
        return "SpeakerListenerLPAConfig{usernameOverride=" + this.usernameOverride + ", sudo=" + this.sudo + ", concurrency=" + this.concurrency + ", minBatchSize=" + this.minBatchSize + ", jobId=" + this.jobId + ", relationshipTypes=" + this.relationshipTypes + ", nodeLabels=" + this.nodeLabels + ", relationshipWeightProperty=" + this.relationshipWeightProperty + ", hasRelationshipWeightProperty=" + this.hasRelationshipWeightProperty + ", maxIterations=" + this.maxIterations + ", partitioning=" + this.partitioning + ", useForkJoin=" + this.useForkJoin + ", writeConcurrency=" + this.writeConcurrency + ", writeProperty=" + this.writeProperty + ", mutateProperty=" + this.mutateProperty + ", minAssociationStrength=" + this.minAssociationStrength + ", isAsynchronous=" + this.isAsynchronous + ", propagationSteps=" + this.propagationSteps + "}";
    }

    public static SpeakerListenerLPA.SpeakerListenerLPAConfig of(int concurrency, int minBatchSize, List<String> relationshipTypes, List<String> nodeLabels, @Nullable String relationshipWeightProperty, int maxIterations, Partitioning partitioning, int writeConcurrency, String writeProperty, String mutateProperty, double minAssociationStrength) {
        return ImmutableSpeakerListenerLPAConfig.of(concurrency, minBatchSize, relationshipTypes, nodeLabels, relationshipWeightProperty, maxIterations, partitioning, writeConcurrency, writeProperty, mutateProperty, minAssociationStrength);
    }

    public static SpeakerListenerLPA.SpeakerListenerLPAConfig of(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, @Nullable String relationshipWeightProperty, int maxIterations, Partitioning partitioning, int writeConcurrency, String writeProperty, String mutateProperty, double minAssociationStrength) {
        return ImmutableSpeakerListenerLPAConfig.validate(new ImmutableSpeakerListenerLPAConfig(concurrency, minBatchSize, relationshipTypes, nodeLabels, relationshipWeightProperty, maxIterations, partitioning, writeConcurrency, writeProperty, mutateProperty, minAssociationStrength));
    }

    private static ImmutableSpeakerListenerLPAConfig validate(ImmutableSpeakerListenerLPAConfig instance) {
        instance.validateWriteConcurrency();
        instance.validateConcurrency();
        return instance;
    }

    public static SpeakerListenerLPA.SpeakerListenerLPAConfig copyOf(SpeakerListenerLPA.SpeakerListenerLPAConfig instance) {
        if (instance instanceof ImmutableSpeakerListenerLPAConfig) {
            return (ImmutableSpeakerListenerLPAConfig)instance;
        }
        return ImmutableSpeakerListenerLPAConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="SpeakerListenerLPA.SpeakerListenerLPAConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_MAX_ITERATIONS = 1L;
        private static final long OPT_BIT_USERNAME_OVERRIDE = 1L;
        private static final long OPT_BIT_SUDO = 2L;
        private static final long OPT_BIT_CONCURRENCY = 4L;
        private static final long OPT_BIT_MIN_BATCH_SIZE = 8L;
        private static final long OPT_BIT_RELATIONSHIP_TYPES = 16L;
        private static final long OPT_BIT_NODE_LABELS = 32L;
        private static final long OPT_BIT_RELATIONSHIP_WEIGHT_PROPERTY = 64L;
        private static final long OPT_BIT_WRITE_CONCURRENCY = 128L;
        private static final long OPT_BIT_MIN_ASSOCIATION_STRENGTH = 256L;
        private long initBits = 1L;
        private long optBits;
        @javax.annotation.Nullable
        private String usernameOverride;
        private boolean sudo;
        @javax.annotation.Nullable
        private Collection<String> configKeys;
        private int concurrency;
        private int minBatchSize;
        @javax.annotation.Nullable
        private JobId jobId;
        private List<String> relationshipTypes = null;
        private List<String> nodeLabels = null;
        @javax.annotation.Nullable
        private String relationshipWeightProperty;
        private int maxIterations;
        @javax.annotation.Nullable
        private Partitioning partitioning;
        private int writeConcurrency;
        @javax.annotation.Nullable
        private String writeProperty;
        @javax.annotation.Nullable
        private String mutateProperty;
        private double minAssociationStrength;

        private Builder() {
        }

        public final Builder from(RelationshipWeightConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(WriteConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(WritePropertyConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(JobIdConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ConcurrencyConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PregelProcedureConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SpeakerListenerLPA.SpeakerListenerLPAConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MutatePropertyConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PregelConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AlgoBaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(IterationsConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            String relationshipWeightPropertyValue;
            long bits = 0L;
            if (object instanceof RelationshipWeightConfig && (relationshipWeightPropertyValue = (instance = (RelationshipWeightConfig)object).relationshipWeightProperty()) != null) {
                this.relationshipWeightProperty(relationshipWeightPropertyValue);
            }
            if (object instanceof WriteConfig) {
                instance = (WriteConfig)object;
                this.writeConcurrency(instance.writeConcurrency());
            }
            if (object instanceof WritePropertyConfig) {
                instance = (WritePropertyConfig)object;
                if ((bits & 1L) == 0L) {
                    this.writeProperty(instance.writeProperty());
                    bits |= 1L;
                }
            }
            if (object instanceof JobIdConfig) {
                instance = (JobIdConfig)object;
                this.jobId(instance.jobId());
            }
            if (object instanceof ConcurrencyConfig) {
                instance = (ConcurrencyConfig)object;
                this.minBatchSize(instance.minBatchSize());
                this.concurrency(instance.concurrency());
            }
            if (object instanceof PregelProcedureConfig) {
                instance = (PregelProcedureConfig)object;
                if ((bits & 1L) == 0L) {
                    this.writeProperty(instance.writeProperty());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.mutateProperty(instance.mutateProperty());
                    bits |= 2L;
                }
            }
            if (object instanceof SpeakerListenerLPA.SpeakerListenerLPAConfig) {
                instance = (SpeakerListenerLPA.SpeakerListenerLPAConfig)object;
                this.minAssociationStrength(instance.minAssociationStrength());
            }
            if (object instanceof MutatePropertyConfig) {
                instance = (MutatePropertyConfig)object;
                if ((bits & 2L) == 0L) {
                    this.mutateProperty(instance.mutateProperty());
                    bits |= 2L;
                }
            }
            if (object instanceof BaseConfig) {
                instance = (BaseConfig)object;
                @Nullable String usernameOverrideValue = instance.usernameOverride();
                if (usernameOverrideValue != null) {
                    this.usernameOverride(usernameOverrideValue);
                }
                this.configKeys(instance.configKeys());
                this.sudo(instance.sudo());
            }
            if (object instanceof PregelConfig) {
                instance = (PregelConfig)object;
                this.partitioning(instance.partitioning());
            }
            if (object instanceof AlgoBaseConfig) {
                instance = (AlgoBaseConfig)object;
                this.addAllRelationshipTypes(instance.relationshipTypes());
                this.addAllNodeLabels(instance.nodeLabels());
            }
            if (object instanceof IterationsConfig) {
                instance = (IterationsConfig)object;
                this.maxIterations(instance.maxIterations());
            }
        }

        public final Builder usernameOverride(@Nullable String usernameOverride) {
            this.usernameOverride = usernameOverride;
            this.optBits |= 1L;
            return this;
        }

        public final Builder sudo(boolean sudo) {
            this.sudo = sudo;
            this.optBits |= 2L;
            return this;
        }

        public final Builder configKeys(Collection<String> configKeys) {
            this.configKeys = Objects.requireNonNull(configKeys, "configKeys");
            return this;
        }

        public final Builder concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.optBits |= 4L;
            return this;
        }

        public final Builder minBatchSize(int minBatchSize) {
            this.minBatchSize = minBatchSize;
            this.optBits |= 8L;
            return this;
        }

        public final Builder jobId(JobId jobId) {
            this.jobId = Objects.requireNonNull(jobId, "jobId");
            return this;
        }

        public final Builder addRelationshipType(String element) {
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder addRelationshipTypes(String ... elements) {
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            }
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder relationshipTypes(Iterable<String> elements) {
            this.relationshipTypes = new ArrayList<String>();
            return this.addAllRelationshipTypes(elements);
        }

        public final Builder addAllRelationshipTypes(Iterable<String> elements) {
            Objects.requireNonNull(elements, "relationshipTypes element");
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            }
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder addNodeLabel(String element) {
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder addNodeLabels(String ... elements) {
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            }
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder nodeLabels(Iterable<String> elements) {
            this.nodeLabels = new ArrayList<String>();
            return this.addAllNodeLabels(elements);
        }

        public final Builder addAllNodeLabels(Iterable<String> elements) {
            Objects.requireNonNull(elements, "nodeLabels element");
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            }
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder relationshipWeightProperty(@Nullable String relationshipWeightProperty) {
            this.relationshipWeightProperty = relationshipWeightProperty;
            this.optBits |= 0x40L;
            return this;
        }

        public final Builder maxIterations(int maxIterations) {
            this.maxIterations = maxIterations;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder partitioning(Partitioning partitioning) {
            this.partitioning = Objects.requireNonNull(partitioning, "partitioning");
            return this;
        }

        public final Builder writeConcurrency(int writeConcurrency) {
            this.writeConcurrency = writeConcurrency;
            this.optBits |= 0x80L;
            return this;
        }

        public final Builder writeProperty(String writeProperty) {
            this.writeProperty = Objects.requireNonNull(writeProperty, "writeProperty");
            return this;
        }

        public final Builder mutateProperty(String mutateProperty) {
            this.mutateProperty = Objects.requireNonNull(mutateProperty, "mutateProperty");
            return this;
        }

        public final Builder minAssociationStrength(double minAssociationStrength) {
            this.minAssociationStrength = minAssociationStrength;
            this.optBits |= 0x100L;
            return this;
        }

        public Builder clear() {
            this.initBits = 1L;
            this.optBits = 0L;
            this.usernameOverride = null;
            this.sudo = false;
            this.configKeys = null;
            this.concurrency = 0;
            this.minBatchSize = 0;
            this.jobId = null;
            if (this.relationshipTypes != null) {
                this.relationshipTypes.clear();
            }
            if (this.nodeLabels != null) {
                this.nodeLabels.clear();
            }
            this.relationshipWeightProperty = null;
            this.maxIterations = 0;
            this.partitioning = null;
            this.writeConcurrency = 0;
            this.writeProperty = null;
            this.mutateProperty = null;
            this.minAssociationStrength = 0.0;
            return this;
        }

        public SpeakerListenerLPA.SpeakerListenerLPAConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableSpeakerListenerLPAConfig.validate(new ImmutableSpeakerListenerLPAConfig(this));
        }

        private boolean usernameOverrideIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean sudoIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean concurrencyIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean minBatchSizeIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean relationshipTypesIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean nodeLabelsIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private boolean relationshipWeightPropertyIsSet() {
            return (this.optBits & 0x40L) != 0L;
        }

        private boolean writeConcurrencyIsSet() {
            return (this.optBits & 0x80L) != 0L;
        }

        private boolean minAssociationStrengthIsSet() {
            return (this.optBits & 0x100L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("maxIterations");
            }
            return "Cannot build SpeakerListenerLPAConfig, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="SpeakerListenerLPA.SpeakerListenerLPAConfig", generator="Immutables")
    private final class InitShim {
        private byte usernameOverrideBuildStage = 0;
        private String usernameOverride;
        private byte sudoBuildStage = 0;
        private boolean sudo;
        private byte configKeysBuildStage = 0;
        private Collection<String> configKeys;
        private byte toMapBuildStage = 0;
        private Map<String, Object> toMap;
        private byte concurrencyBuildStage = 0;
        private int concurrency;
        private byte minBatchSizeBuildStage = 0;
        private int minBatchSize;
        private byte jobIdBuildStage = 0;
        private JobId jobId;
        private byte relationshipTypesBuildStage = 0;
        private List<String> relationshipTypes;
        private byte nodeLabelsBuildStage = 0;
        private List<String> nodeLabels;
        private byte relationshipWeightPropertyBuildStage = 0;
        private String relationshipWeightProperty;
        private byte hasRelationshipWeightPropertyBuildStage = 0;
        private boolean hasRelationshipWeightProperty;
        private byte partitioningBuildStage = 0;
        private Partitioning partitioning;
        private byte useForkJoinBuildStage = 0;
        private boolean useForkJoin;
        private byte writeConcurrencyBuildStage = 0;
        private int writeConcurrency;
        private byte writePropertyBuildStage = 0;
        private String writeProperty;
        private byte mutatePropertyBuildStage = 0;
        private String mutateProperty;
        private byte minAssociationStrengthBuildStage = 0;
        private double minAssociationStrength;
        private byte isAsynchronousBuildStage = 0;
        private boolean isAsynchronous;
        private byte propagationStepsBuildStage = 0;
        private int propagationSteps;

        private InitShim() {
        }

        String usernameOverride() {
            if (this.usernameOverrideBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.usernameOverrideBuildStage == 0) {
                this.usernameOverrideBuildStage = (byte)-1;
                this.usernameOverride = ImmutableSpeakerListenerLPAConfig.this.usernameOverrideInitialize();
                this.usernameOverrideBuildStage = 1;
            }
            return this.usernameOverride;
        }

        void usernameOverride(String usernameOverride) {
            this.usernameOverride = usernameOverride;
            this.usernameOverrideBuildStage = 1;
        }

        boolean sudo() {
            if (this.sudoBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sudoBuildStage == 0) {
                this.sudoBuildStage = (byte)-1;
                this.sudo = ImmutableSpeakerListenerLPAConfig.this.sudoInitialize();
                this.sudoBuildStage = 1;
            }
            return this.sudo;
        }

        void sudo(boolean sudo) {
            this.sudo = sudo;
            this.sudoBuildStage = 1;
        }

        Collection<String> configKeys() {
            if (this.configKeysBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.configKeysBuildStage == 0) {
                this.configKeysBuildStage = (byte)-1;
                this.configKeys = Objects.requireNonNull(ImmutableSpeakerListenerLPAConfig.this.configKeysInitialize(), "configKeys");
                this.configKeysBuildStage = 1;
            }
            return this.configKeys;
        }

        void configKeys(Collection<String> configKeys) {
            this.configKeys = configKeys;
            this.configKeysBuildStage = 1;
        }

        Map<String, Object> toMap() {
            if (this.toMapBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.toMapBuildStage == 0) {
                this.toMapBuildStage = (byte)-1;
                this.toMap = Objects.requireNonNull(ImmutableSpeakerListenerLPAConfig.this.toMapInitialize(), "toMap");
                this.toMapBuildStage = 1;
            }
            return this.toMap;
        }

        int concurrency() {
            if (this.concurrencyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.concurrencyBuildStage == 0) {
                this.concurrencyBuildStage = (byte)-1;
                this.concurrency = ImmutableSpeakerListenerLPAConfig.this.concurrencyInitialize();
                this.concurrencyBuildStage = 1;
            }
            return this.concurrency;
        }

        void concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.concurrencyBuildStage = 1;
        }

        int minBatchSize() {
            if (this.minBatchSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.minBatchSizeBuildStage == 0) {
                this.minBatchSizeBuildStage = (byte)-1;
                this.minBatchSize = ImmutableSpeakerListenerLPAConfig.this.minBatchSizeInitialize();
                this.minBatchSizeBuildStage = 1;
            }
            return this.minBatchSize;
        }

        void minBatchSize(int minBatchSize) {
            this.minBatchSize = minBatchSize;
            this.minBatchSizeBuildStage = 1;
        }

        JobId jobId() {
            if (this.jobIdBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.jobIdBuildStage == 0) {
                this.jobIdBuildStage = (byte)-1;
                this.jobId = Objects.requireNonNull(ImmutableSpeakerListenerLPAConfig.this.jobIdInitialize(), "jobId");
                this.jobIdBuildStage = 1;
            }
            return this.jobId;
        }

        void jobId(JobId jobId) {
            this.jobId = jobId;
            this.jobIdBuildStage = 1;
        }

        List<String> relationshipTypes() {
            if (this.relationshipTypesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.relationshipTypesBuildStage == 0) {
                this.relationshipTypesBuildStage = (byte)-1;
                this.relationshipTypes = ImmutableSpeakerListenerLPAConfig.createUnmodifiableList(false, ImmutableSpeakerListenerLPAConfig.createSafeList(ImmutableSpeakerListenerLPAConfig.this.relationshipTypesInitialize(), true, false));
                this.relationshipTypesBuildStage = 1;
            }
            return this.relationshipTypes;
        }

        void relationshipTypes(List<String> relationshipTypes) {
            this.relationshipTypes = relationshipTypes;
            this.relationshipTypesBuildStage = 1;
        }

        List<String> nodeLabels() {
            if (this.nodeLabelsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.nodeLabelsBuildStage == 0) {
                this.nodeLabelsBuildStage = (byte)-1;
                this.nodeLabels = ImmutableSpeakerListenerLPAConfig.createUnmodifiableList(false, ImmutableSpeakerListenerLPAConfig.createSafeList(ImmutableSpeakerListenerLPAConfig.this.nodeLabelsInitialize(), true, false));
                this.nodeLabelsBuildStage = 1;
            }
            return this.nodeLabels;
        }

        void nodeLabels(List<String> nodeLabels) {
            this.nodeLabels = nodeLabels;
            this.nodeLabelsBuildStage = 1;
        }

        String relationshipWeightProperty() {
            if (this.relationshipWeightPropertyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.relationshipWeightPropertyBuildStage == 0) {
                this.relationshipWeightPropertyBuildStage = (byte)-1;
                this.relationshipWeightProperty = ImmutableSpeakerListenerLPAConfig.this.relationshipWeightPropertyInitialize();
                this.relationshipWeightPropertyBuildStage = 1;
            }
            return this.relationshipWeightProperty;
        }

        void relationshipWeightProperty(String relationshipWeightProperty) {
            this.relationshipWeightProperty = relationshipWeightProperty;
            this.relationshipWeightPropertyBuildStage = 1;
        }

        boolean hasRelationshipWeightProperty() {
            if (this.hasRelationshipWeightPropertyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hasRelationshipWeightPropertyBuildStage == 0) {
                this.hasRelationshipWeightPropertyBuildStage = (byte)-1;
                this.hasRelationshipWeightProperty = ImmutableSpeakerListenerLPAConfig.this.hasRelationshipWeightPropertyInitialize();
                this.hasRelationshipWeightPropertyBuildStage = 1;
            }
            return this.hasRelationshipWeightProperty;
        }

        Partitioning partitioning() {
            if (this.partitioningBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.partitioningBuildStage == 0) {
                this.partitioningBuildStage = (byte)-1;
                this.partitioning = Objects.requireNonNull(ImmutableSpeakerListenerLPAConfig.this.partitioningInitialize(), "partitioning");
                this.partitioningBuildStage = 1;
            }
            return this.partitioning;
        }

        void partitioning(Partitioning partitioning) {
            this.partitioning = partitioning;
            this.partitioningBuildStage = 1;
        }

        boolean useForkJoin() {
            if (this.useForkJoinBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.useForkJoinBuildStage == 0) {
                this.useForkJoinBuildStage = (byte)-1;
                this.useForkJoin = ImmutableSpeakerListenerLPAConfig.this.useForkJoinInitialize();
                this.useForkJoinBuildStage = 1;
            }
            return this.useForkJoin;
        }

        int writeConcurrency() {
            if (this.writeConcurrencyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.writeConcurrencyBuildStage == 0) {
                this.writeConcurrencyBuildStage = (byte)-1;
                this.writeConcurrency = ImmutableSpeakerListenerLPAConfig.this.writeConcurrencyInitialize();
                this.writeConcurrencyBuildStage = 1;
            }
            return this.writeConcurrency;
        }

        void writeConcurrency(int writeConcurrency) {
            this.writeConcurrency = writeConcurrency;
            this.writeConcurrencyBuildStage = 1;
        }

        String writeProperty() {
            if (this.writePropertyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.writePropertyBuildStage == 0) {
                this.writePropertyBuildStage = (byte)-1;
                this.writeProperty = Objects.requireNonNull(ImmutableSpeakerListenerLPAConfig.this.writePropertyInitialize(), "writeProperty");
                this.writePropertyBuildStage = 1;
            }
            return this.writeProperty;
        }

        void writeProperty(String writeProperty) {
            this.writeProperty = writeProperty;
            this.writePropertyBuildStage = 1;
        }

        String mutateProperty() {
            if (this.mutatePropertyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.mutatePropertyBuildStage == 0) {
                this.mutatePropertyBuildStage = (byte)-1;
                this.mutateProperty = Objects.requireNonNull(ImmutableSpeakerListenerLPAConfig.this.mutatePropertyInitialize(), "mutateProperty");
                this.mutatePropertyBuildStage = 1;
            }
            return this.mutateProperty;
        }

        void mutateProperty(String mutateProperty) {
            this.mutateProperty = mutateProperty;
            this.mutatePropertyBuildStage = 1;
        }

        double minAssociationStrength() {
            if (this.minAssociationStrengthBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.minAssociationStrengthBuildStage == 0) {
                this.minAssociationStrengthBuildStage = (byte)-1;
                this.minAssociationStrength = ImmutableSpeakerListenerLPAConfig.this.minAssociationStrengthInitialize();
                this.minAssociationStrengthBuildStage = 1;
            }
            return this.minAssociationStrength;
        }

        void minAssociationStrength(double minAssociationStrength) {
            this.minAssociationStrength = minAssociationStrength;
            this.minAssociationStrengthBuildStage = 1;
        }

        boolean isAsynchronous() {
            if (this.isAsynchronousBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isAsynchronousBuildStage == 0) {
                this.isAsynchronousBuildStage = (byte)-1;
                this.isAsynchronous = ImmutableSpeakerListenerLPAConfig.this.isAsynchronousInitialize();
                this.isAsynchronousBuildStage = 1;
            }
            return this.isAsynchronous;
        }

        int propagationSteps() {
            if (this.propagationStepsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.propagationStepsBuildStage == 0) {
                this.propagationStepsBuildStage = (byte)-1;
                this.propagationSteps = ImmutableSpeakerListenerLPAConfig.this.propagationStepsInitialize();
                this.propagationStepsBuildStage = 1;
            }
            return this.propagationSteps;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.usernameOverrideBuildStage == -1) {
                attributes.add("usernameOverride");
            }
            if (this.sudoBuildStage == -1) {
                attributes.add("sudo");
            }
            if (this.configKeysBuildStage == -1) {
                attributes.add("configKeys");
            }
            if (this.toMapBuildStage == -1) {
                attributes.add("toMap");
            }
            if (this.concurrencyBuildStage == -1) {
                attributes.add("concurrency");
            }
            if (this.minBatchSizeBuildStage == -1) {
                attributes.add("minBatchSize");
            }
            if (this.jobIdBuildStage == -1) {
                attributes.add("jobId");
            }
            if (this.relationshipTypesBuildStage == -1) {
                attributes.add("relationshipTypes");
            }
            if (this.nodeLabelsBuildStage == -1) {
                attributes.add("nodeLabels");
            }
            if (this.relationshipWeightPropertyBuildStage == -1) {
                attributes.add("relationshipWeightProperty");
            }
            if (this.hasRelationshipWeightPropertyBuildStage == -1) {
                attributes.add("hasRelationshipWeightProperty");
            }
            if (this.partitioningBuildStage == -1) {
                attributes.add("partitioning");
            }
            if (this.useForkJoinBuildStage == -1) {
                attributes.add("useForkJoin");
            }
            if (this.writeConcurrencyBuildStage == -1) {
                attributes.add("writeConcurrency");
            }
            if (this.writePropertyBuildStage == -1) {
                attributes.add("writeProperty");
            }
            if (this.mutatePropertyBuildStage == -1) {
                attributes.add("mutateProperty");
            }
            if (this.minAssociationStrengthBuildStage == -1) {
                attributes.add("minAssociationStrength");
            }
            if (this.isAsynchronousBuildStage == -1) {
                attributes.add("isAsynchronous");
            }
            if (this.propagationStepsBuildStage == -1) {
                attributes.add("propagationSteps");
            }
            return "Cannot build SpeakerListenerLPAConfig, attribute initializers form cycle " + attributes;
        }
    }
}

