/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.spanningtree;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.impl.spanningTrees.Prim;
import org.neo4j.gds.spanningtree.SpanningTreeConfig;
import org.neo4j.gds.spanningtree.SpanningTreeProc;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@GdsCallable(name="gds.alpha.spanningTree.write", description="Minimum weight spanning tree visits all nodes that are in the same connected component as the starting node, and returns a spanning tree of all nodes in the component where the total weight of the relationships is minimized.", executionMode=ExecutionMode.WRITE_NODE_PROPERTY)
public class SpanningTreeProcMin
extends SpanningTreeProc {
    static final String MIN_DESCRIPTION = "Minimum weight spanning tree visits all nodes that are in the same connected component as the starting node, and returns a spanning tree of all nodes in the component where the total weight of the relationships is minimized.";

    @Procedure(value="gds.alpha.spanningTree.write", mode=Mode.WRITE)
    @Description(value="Minimum weight spanning tree visits all nodes that are in the same connected component as the starting node, and returns a spanning tree of all nodes in the component where the total weight of the relationships is minimized.")
    public Stream<Prim.Result> spanningTree(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        ComputationResult computationResult = this.compute(graphName, configuration);
        return (Stream)this.computationResultConsumer().consume(computationResult, this.executionContext());
    }

    @Procedure(value="gds.alpha.spanningTree.minimum.write", mode=Mode.WRITE)
    @Description(value="Minimum weight spanning tree visits all nodes that are in the same connected component as the starting node, and returns a spanning tree of all nodes in the component where the total weight of the relationships is minimized.")
    public Stream<Prim.Result> minimumSpanningTree(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        ComputationResult computationResult = this.compute(graphName, configuration);
        return (Stream)this.computationResultConsumer().consume(computationResult, this.executionContext());
    }

    protected SpanningTreeConfig newConfig(String username, CypherMapWrapper config) {
        return SpanningTreeConfig.of(Prim.MIN_OPERATOR, config);
    }
}

