/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.triangle;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.stream.Stream;
import org.neo4j.gds.AlgoBaseProc;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.concurrency.Pools;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ComputationResultConsumer;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.executor.validation.BeforeLoadValidation;
import org.neo4j.gds.executor.validation.GraphProjectConfigValidations;
import org.neo4j.gds.executor.validation.ValidationConfiguration;
import org.neo4j.gds.impl.triangle.TriangleStream;
import org.neo4j.gds.triangle.TriangleCountBaseConfig;
import org.neo4j.kernel.api.Statement;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@GdsCallable(name="gds.alpha.triangles", description="Triangles streams the nodeIds of each triangle in the graph.", executionMode=ExecutionMode.STREAM)
public class TriangleProc
extends AlgoBaseProc<TriangleStream, Stream<TriangleStream.Result>, TriangleCountBaseConfig, TriangleStream.Result> {
    static final String DESCRIPTION = "Triangles streams the nodeIds of each triangle in the graph.";

    @Procedure(name="gds.alpha.triangles", mode=Mode.READ)
    @Description(value="Triangles streams the nodeIds of each triangle in the graph.")
    public Stream<TriangleStream.Result> stream(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        ComputationResult computationResult = this.compute(graphName, configuration, false, false);
        return (Stream)this.computationResultConsumer().consume(computationResult, this.executionContext());
    }

    protected TriangleCountBaseConfig newConfig(String username, CypherMapWrapper config) {
        return TriangleCountBaseConfig.of((CypherMapWrapper)config);
    }

    public ValidationConfiguration<TriangleCountBaseConfig> validationConfig() {
        return new ValidationConfiguration<TriangleCountBaseConfig>(){

            public List<BeforeLoadValidation<TriangleCountBaseConfig>> beforeLoadValidations() {
                return List.of(new GraphProjectConfigValidations.UndirectedGraphValidation());
            }
        };
    }

    public GraphAlgorithmFactory<TriangleStream, TriangleCountBaseConfig> algorithmFactory() {
        return new GraphAlgorithmFactory<TriangleStream, TriangleCountBaseConfig>(){

            public String taskName() {
                return "TriangleStream";
            }

            public TriangleStream build(Graph graph, TriangleCountBaseConfig configuration, ProgressTracker progressTracker) {
                return TriangleStream.create((Graph)graph, (ExecutorService)Pools.DEFAULT, (int)configuration.concurrency());
            }
        };
    }

    public ComputationResultConsumer<TriangleStream, Stream<TriangleStream.Result>, TriangleCountBaseConfig, Stream<TriangleStream.Result>> computationResultConsumer() {
        return (computationResult, executionContext) -> {
            Graph graph = computationResult.graph();
            if (graph.isEmpty()) {
                graph.release();
                return Stream.empty();
            }
            Stream resultStream = (Stream)computationResult.result();
            try (Statement statement = this.transaction.acquireStatement();){
                statement.registerCloseableResource((AutoCloseable)resultStream);
            }
            return resultStream;
        };
    }
}

