/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.conductance;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.StreamProc;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.conductance.ConductanceProc;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.impl.conductance.Conductance;
import org.neo4j.gds.impl.conductance.ConductanceStreamConfig;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@GdsCallable(name="gds.alpha.conductance.stream", description="Evaluates a division of nodes into communities based on the proportion of relationships that cross community boundaries.", executionMode=ExecutionMode.STREAM)
public class ConductanceStreamProc
extends StreamProc<Conductance, Conductance.Result, StreamResult, ConductanceStreamConfig> {
    @Procedure(value="gds.alpha.conductance.stream", mode=Mode.READ)
    @Description(value="Evaluates a division of nodes into communities based on the proportion of relationships that cross community boundaries.")
    public Stream<StreamResult> stream(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        ComputationResult result = this.compute(graphName, configuration);
        if (result.isGraphEmpty()) {
            result.graph().release();
            return Stream.empty();
        }
        return ((Conductance.Result)result.result()).streamCommunityResults().map(communityResult -> new StreamResult(communityResult.community(), communityResult.conductance()));
    }

    protected ConductanceStreamConfig newConfig(String username, CypherMapWrapper config) {
        return ConductanceStreamConfig.of((CypherMapWrapper)config);
    }

    public GraphAlgorithmFactory<Conductance, ConductanceStreamConfig> algorithmFactory() {
        return ConductanceProc.algorithmFactory();
    }

    protected StreamResult streamResult(long originalNodeId, long internalNodeId, NodePropertyValues nodePropertyValues) {
        throw new UnsupportedOperationException("Conductance handles result building individually.");
    }

    public static class StreamResult {
        public final long community;
        public final double conductance;

        public StreamResult(long community, double conductance) {
            this.community = community;
            this.conductance = conductance;
        }
    }
}

